/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.internal.wizards.datatransfer.SmartImportJob;

public class ImportProjectAction
extends SelectionProviderAction {
    protected CodewindApplication app;

    public ImportProjectAction(ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.ImportProjectActionLabel);
        this.setImageDescriptor(CodewindUIPlugin.getImageDescriptor("elcl16/import_wiz.png"));
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        Object obj;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof CodewindApplication) {
            this.app = (CodewindApplication)obj;
            if (this.app.isAvailable()) {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.app.name);
                this.setEnabled(project == null || !project.exists());
                return;
            }
        }
        this.setEnabled(false);
    }

    public void run() {
        if (this.app == null) {
            Logger.logError((String)"ImportProjectAction ran but no application was selected");
            return;
        }
        ImportProjectAction.importProject(this.app);
    }

    public static void importProject(CodewindApplication app) {
        try {
            IPath path = app.fullLocalPath;
            SmartImportJob importJob = new SmartImportJob(path.toFile(), null, true, false);
            importJob.schedule();
        }
        catch (Exception e) {
            Logger.logError((String)("Error importing project: " + app.name), (Throwable)e);
            CoreUtil.openDialog((boolean)true, (String)NLS.bind((String)Messages.ImportProjectError, (Object)app.name), (String)e.getMessage());
            return;
        }
    }
}

