/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.constants.AppStatus;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.prefs.LinkManagementDialog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionProviderAction;

public class ManageLinksAction
extends SelectionProviderAction {
    protected CodewindApplication app;

    public ManageLinksAction(ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.LinkMgmtActionLabel);
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        Object obj;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof CodewindApplication) {
            this.app = (CodewindApplication)obj;
            this.setEnabled(this.app.isAvailable() && this.app.getAppStatus() == AppStatus.STARTED);
            return;
        }
        this.setEnabled(false);
    }

    public void run() {
        if (this.app == null) {
            Logger.logError((String)"ManageLinksAction ran but no Codewind application was selected");
            return;
        }
        ManageLinksAction.openManageLinksDialog(this.app);
    }

    public static void openManageLinksDialog(CodewindApplication app) {
        try {
            final LinkManagementDialog linkDialog = new LinkManagementDialog(Display.getDefault().getActiveShell(), app);
            if (linkDialog.open() == 0 && linkDialog.hasChanges()) {
                Job job = new Job(Messages.LinkUpdateTask){

                    protected IStatus run(IProgressMonitor monitor) {
                        return linkDialog.updateLinks(monitor);
                    }
                };
                job.schedule();
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.LinkListErrorTitle, (String)NLS.bind((String)Messages.LinkListErrorMsg, (Object)e));
        }
    }
}

