/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CodewindManager;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.LocalConnection;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.views.ViewHelper;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class RefreshAction
implements IObjectActionDelegate {
    protected Object codewindObject;

    public void selectionChanged(IAction action, ISelection selection) {
        Object obj;
        if (!(selection instanceof IStructuredSelection)) {
            action.setEnabled(false);
            return;
        }
        IStructuredSelection sel = (IStructuredSelection)selection;
        if (sel.size() == 1 && ((obj = sel.getFirstElement()) instanceof CodewindManager || obj instanceof CodewindConnection || obj instanceof CodewindApplication)) {
            this.codewindObject = obj;
            action.setEnabled(true);
            return;
        }
        action.setEnabled(false);
    }

    public void run(IAction action) {
        if (this.codewindObject instanceof CodewindManager) {
            Job job = new Job(Messages.RefreshCodewindJobLabel){

                protected IStatus run(IProgressMonitor monitor) {
                    IStatus status = ((CodewindManager)RefreshAction.this.codewindObject).refresh(monitor);
                    ViewHelper.refreshCodewindExplorerView(RefreshAction.this.codewindObject);
                    return status;
                }
            };
            job.schedule();
        } else if (this.codewindObject instanceof LocalConnection) {
            final LocalConnection connection = (LocalConnection)this.codewindObject;
            Job job = new Job(NLS.bind((String)Messages.RefreshConnectionJobLabel, (Object)connection.getName())){

                protected IStatus run(IProgressMonitor monitor) {
                    CodewindManager.getManager().refreshInstallStatus(monitor);
                    if (connection.isConnected()) {
                        connection.refreshApps(null);
                    }
                    ViewHelper.refreshCodewindExplorerView(connection);
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        } else if (this.codewindObject instanceof CodewindConnection) {
            final CodewindConnection connection = (CodewindConnection)this.codewindObject;
            Job job = new Job(NLS.bind((String)Messages.RefreshConnectionJobLabel, (Object)connection.getName())){

                protected IStatus run(IProgressMonitor monitor) {
                    connection.refreshApps(null);
                    ViewHelper.refreshCodewindExplorerView(connection);
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        } else if (this.codewindObject instanceof CodewindApplication) {
            final CodewindApplication app = (CodewindApplication)this.codewindObject;
            Job job = new Job(NLS.bind((String)Messages.RefreshProjectJobLabel, (Object)app.name)){

                protected IStatus run(IProgressMonitor monitor) {
                    app.connection.refreshApps(app.projectID);
                    ViewHelper.refreshCodewindExplorerView(app);
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        } else {
            Logger.logError((String)"RefreshAction ran but no Codewind object was selected");
        }
    }

    public void setActivePart(IAction arg0, IWorkbenchPart arg1) {
    }
}

