/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.prefs;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.codewind.core.internal.HttpUtil;
import org.eclipse.codewind.core.internal.IAuthInfo;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.IDEUtil;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.prefs.TemplateSourceAuthComposite;
import org.eclipse.codewind.ui.internal.wizards.CompositeContainer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class TemplateSourceURLPage
extends WizardPage
implements CompositeContainer {
    private Text urlText;
    private String urlValue;
    private boolean authRequiredValue = false;
    private TemplateSourceAuthComposite authComposite;
    private boolean isLogonMethod = true;
    private String username;
    private Button testButton;

    protected TemplateSourceURLPage(String shellTitle, String pageTitle) {
        super(shellTitle);
        this.setTitle(pageTitle);
        this.setDescription(Messages.AddRepoURLPageMessage);
    }

    protected TemplateSourceURLPage(String shellTitle, String pageTitle, String url, boolean requiresAuthentication, boolean isLogonMethod, String username) {
        this(shellTitle, pageTitle);
        this.urlValue = url;
        this.authRequiredValue = requiresAuthentication;
        this.isLogonMethod = isLogonMethod;
        this.username = username;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 5;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        composite.setLayoutData((Object)data);
        Label label = new Label(composite, 0);
        label.setText(Messages.AddRepoDialogUrlLabel);
        label.setLayoutData((Object)new GridData(4, 4, false, false));
        this.urlText = new Text(composite, 2048);
        this.urlText.setLayoutData((Object)new GridData(4, 4, true, false));
        new Label(composite, 0).setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        final Button authRequiredButton = new Button(composite, 32);
        authRequiredButton.setText(Messages.AddRepoDialogAuthRequiredCheckboxLabel);
        authRequiredButton.setToolTipText(Messages.AddRepoDialogAuthRequiredCheckboxTooltip);
        authRequiredButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        authRequiredButton.setSelection(this.authRequiredValue);
        this.authComposite = new TemplateSourceAuthComposite(composite, this, this.isLogonMethod, this.username);
        this.authComposite.hideTestButton();
        this.authComposite.setLayoutData(new GridData(4, 4, true, false, 2, 1));
        new Label(composite, 0).setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        this.testButton = new Button(composite, 8);
        this.testButton.setText(Messages.AddRepoDialogTestButtonLabel);
        this.testButton.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false, 2, 1));
        this.urlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                TemplateSourceURLPage.this.urlValue = IDEUtil.getTextValue(TemplateSourceURLPage.this.urlText);
                TemplateSourceURLPage.this.authComposite.updatePage(TemplateSourceURLPage.this.urlValue);
                TemplateSourceURLPage.this.validate();
            }
        });
        authRequiredButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TemplateSourceURLPage.this.authRequiredValue = authRequiredButton.getSelection();
                TemplateSourceURLPage.this.authComposite.setCompositeEnabled(TemplateSourceURLPage.this.authRequiredValue);
                TemplateSourceURLPage.this.validate();
            }
        });
        this.testButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.AddRepoDialogTestTaskLabel, (Object)TemplateSourceURLPage.this.urlValue), (int)-1);
                            URI uri = new URI(TemplateSourceURLPage.this.urlValue);
                            HttpUtil.HttpResult result = HttpUtil.get((URI)uri, (IAuthInfo)TemplateSourceURLPage.this.getAuthInfo());
                            if (!result.isGoodResponse) {
                                String errorMsg = result.error;
                                if (errorMsg == null || errorMsg.trim().isEmpty()) {
                                    errorMsg = NLS.bind((String)Messages.AddRepoDialogTestFailedDefaultMsg, (Object)result.responseCode);
                                }
                                throw new InvocationTargetException(new IOException(errorMsg));
                            }
                        }
                        catch (Exception e) {
                            if (e instanceof InvocationTargetException) {
                                throw (InvocationTargetException)e;
                            }
                            throw new InvocationTargetException(e, e.toString());
                        }
                    }
                };
                try {
                    TemplateSourceURLPage.this.run(runnable);
                    TemplateSourceURLPage.this.setErrorMessage(null);
                    TemplateSourceURLPage.this.setMessage(Messages.AddRepoDialogTestSuccessMsg);
                }
                catch (Exception e) {
                    String msg = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException().toString() : e.toString();
                    IDEUtil.openInfoDialog(Messages.AddRepoDialogTestFailedTitle, NLS.bind((String)Messages.AddRepoDialogTestFailedError, (Object)TemplateSourceURLPage.this.urlValue, (Object)msg));
                    TemplateSourceURLPage.this.setErrorMessage(Messages.AddRepoDialogTestFailedMsg);
                }
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, CodewindUIPlugin.MAIN_CONTEXTID);
        if (this.urlValue != null) {
            this.urlText.setText(this.urlValue);
        }
        this.authComposite.setCompositeEnabled(this.authRequiredValue);
        this.testButton.setEnabled(this.urlValue != null);
        this.setControl((Control)composite);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.urlText.setFocus();
        }
    }

    @Override
    public void validate() {
        String errorMsg = null;
        if (this.urlValue == null) {
            errorMsg = Messages.AddRepoDialogNoUrl;
        }
        String authError = this.authComposite.validate();
        this.setMessage(Messages.AddRepoURLPageMessage);
        this.setErrorMessage(errorMsg != null ? errorMsg : authError);
        this.testButton.setEnabled(this.urlValue != null);
        this.getContainer().updateButtons();
    }

    public boolean canFlipToNextPage() {
        return this.canFinish();
    }

    boolean isActivePage() {
        return this.isCurrentPage();
    }

    boolean canFinish() {
        return this.urlValue != null && (!this.authRequiredValue || this.authComposite.canFinish());
    }

    String getTemplateSourceUrl() {
        return this.urlValue;
    }

    boolean getAuthRequired() {
        return this.authRequiredValue;
    }

    String getUsername() {
        return this.authRequiredValue ? this.authComposite.getUsername() : null;
    }

    String getPassword() {
        return this.authRequiredValue ? this.authComposite.getPassword() : null;
    }

    String getToken() {
        return this.authRequiredValue ? this.authComposite.getToken() : null;
    }

    IAuthInfo getAuthInfo() {
        return this.authRequiredValue ? this.authComposite.getAuthInfo() : null;
    }

    @Override
    public void run(IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        this.getWizard().getContainer().run(true, true, runnable);
    }
}

