/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import java.net.URL;
import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.constants.AppStatus;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class OpenAppAction
extends SelectionProviderAction {
    public static final String ACTION_ID = "org.eclipse.codewind.ui.openAppAction";
    protected CodewindApplication app;

    public OpenAppAction(ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.OpenAppAction_Label);
        this.setImageDescriptor(CodewindUIPlugin.getImageDescriptor("elcl16/open_app.png"));
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        Object obj;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof CodewindApplication) {
            this.app = (CodewindApplication)obj;
            this.setEnabled(this.app.isAvailable() && (this.app.getAppStatus() == AppStatus.STARTING || this.app.getAppStatus() == AppStatus.STARTED));
            return;
        }
        this.setEnabled(false);
    }

    public void run() {
        if (this.app == null) {
            Logger.logError((String)"OpenAppAction ran but no application was selected");
            return;
        }
        if (!this.app.isRunning()) {
            CoreUtil.openDialog((boolean)true, (String)Messages.OpenAppAction_CantOpenNotRunningAppTitle, (String)Messages.OpenAppAction_CantOpenNotRunningAppMsg);
            return;
        }
        OpenAppAction.openAppInBrowser(this.app);
    }

    public static void openAppInBrowser(CodewindApplication app) {
        URL appRootUrl = app.getRootUrl();
        if (appRootUrl == null) {
            Logger.logError((String)("The application could not be opened in the browser because the url is null: " + app.name));
            return;
        }
        try {
            IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
            IWebBrowser browser = browserSupport.createBrowser(6, app.projectID, app.name, NLS.bind((String)Messages.BrowserTooltipApp, (Object)app.name));
            browser.openURL(appRootUrl);
        }
        catch (PartInitException e) {
            Logger.logError((String)"Error opening app in browser", (Throwable)e);
        }
    }
}

