/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.launch;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Map;
import org.eclipse.codewind.core.CodewindCorePlugin;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.launch.LaunchUtilities;
import org.eclipse.codewind.core.internal.messages.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.osgi.util.NLS;

public class CodewindDebugConnector {
    public static IDebugTarget connectDebugger(ILaunch launch, IProgressMonitor monitor) throws IllegalConnectorArgumentsException, CoreException, IOException {
        Logger.log("Beginning to try to connect debugger");
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        String projectName = config.getAttribute("org.eclipse.codewind.core.internal.projectNameAttr", (String)null);
        String host = config.getAttribute("org.eclipse.codewind.core.internal.hostAttr", (String)null);
        int debugPort = config.getAttribute("org.eclipse.codewind.core.internal.debugPort", -1);
        if (projectName == null || host == null || debugPort <= 0) {
            String msg = "The launch configuration did not contain the required attributes: " + config.getName();
            Logger.logError(msg);
            return null;
        }
        Logger.log("Debugging on port " + debugPort);
        int timeout = CodewindCorePlugin.getDefault().getPreferenceStore().getInt("serverDebugTimeout") * 1000;
        Logger.log("Debugger connect timeout is " + timeout + "ms");
        AttachingConnector connector = LaunchUtilities.getAttachingConnector();
        if (connector == null) {
            Logger.logError("Could not create debug connector");
            return null;
        }
        Map<String, Connector.Argument> connectorArgs = connector.defaultArguments();
        connectorArgs = LaunchUtilities.configureConnector(connectorArgs, host, debugPort);
        boolean retry = false;
        try {
            VirtualMachine vm = null;
            Exception ex = null;
            int itr = timeout * 4;
            if (itr <= 0) {
                itr = 2;
            }
            while (itr-- > 0) {
                block15: {
                    if (monitor.isCanceled()) {
                        Logger.log("User cancelled debugger connecting");
                        return null;
                    }
                    try {
                        vm = connector.attach(connectorArgs);
                        itr = 0;
                        ex = null;
                    }
                    catch (Exception e) {
                        ex = e;
                        if (itr % 8 != 0) break block15;
                        Logger.log("Waiting for debugger attach.");
                    }
                }
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException e) {}
            }
            if (ex instanceof IllegalConnectorArgumentsException) {
                throw (IllegalConnectorArgumentsException)ex;
            }
            if (ex instanceof InterruptedIOException) {
                throw (InterruptedIOException)ex;
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            IDebugTarget debugTarget = null;
            if (vm != null) {
                LaunchUtilities.setDebugTimeout(vm);
                String debugName = CodewindDebugConnector.getDebugLaunchName(projectName, host, String.valueOf(debugPort));
                debugTarget = LaunchUtilities.createLocalJDTDebugTarget(launch, debugPort, null, vm, debugName, false);
                monitor.worked(1);
                monitor.done();
            }
            return debugTarget;
        }
        catch (InterruptedIOException e) {
            Status status = new Status(4, "org.eclipse.codewind.core", 117, "", (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private static String getDebugLaunchName(String projectName, String host, String debugPort) {
        return NLS.bind((String)Messages.DebugLaunchConfigName, (Object[])new Object[]{projectName, host, debugPort});
    }
}

