/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.cli.ProjectUtil;
import org.eclipse.codewind.core.internal.cli.RegistryUtil;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.ImagePushRegistryInfo;
import org.eclipse.codewind.core.internal.constants.ProjectInfo;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.IDEUtil;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.prefs.RegistryManagementDialog;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ProjectValidationPage
extends WizardPage {
    private CodewindConnection connection;
    private IProject project;
    private IPath projectPath;
    private ProjectInfo projectInfo;
    private Text validateMsg;
    private Label typeLabel;
    private Label languageLabel;
    private Text typeText;
    private Text languageText;
    private Font boldFont;
    private Composite manageRegistriesComp;

    protected ProjectValidationPage(CodewindConnection connection, IProject project) {
        super(Messages.ProjectValidationPageName);
        this.setTitle(Messages.ProjectValidationPageTitle);
        this.setDescription(Messages.ProjectValidationPageDescription);
        this.connection = connection;
        this.project = project;
        if (project != null) {
            this.projectPath = project.getLocation();
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 7;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4));
        this.validateMsg = new Text(composite, 74);
        this.validateMsg.setText("");
        GridData data = new GridData(4, 2, true, false, 2, 1);
        data.widthHint = 200;
        this.validateMsg.setLayoutData((Object)data);
        IDEUtil.normalizeBackground((Control)this.validateMsg, (Control)composite);
        new Label(composite, 0).setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        Composite typeComp = new Composite(composite, 0);
        layout = new GridLayout();
        layout.marginTop = 10;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 7;
        layout.numColumns = 2;
        typeComp.setLayout((Layout)layout);
        typeComp.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        this.boldFont = IDEUtil.newFont(this.getShell(), this.getFont(), 1);
        this.typeLabel = new Label(typeComp, 0);
        this.typeLabel.setText("Type:");
        data = new GridData(3, 2, false, false);
        data.horizontalIndent = 20;
        this.typeLabel.setLayoutData((Object)data);
        this.typeText = new Text(typeComp, 8);
        this.typeText.setFont(this.boldFont);
        this.typeText.setText("");
        this.typeText.setLayoutData((Object)new GridData(4, 2, true, false));
        IDEUtil.normalizeBackground((Control)this.typeText, (Control)typeComp);
        this.languageLabel = new Label(typeComp, 0);
        this.languageLabel.setText("Language:");
        data = new GridData(3, 2, false, false);
        data.horizontalIndent = 20;
        this.languageLabel.setLayoutData((Object)data);
        this.languageText = new Text(typeComp, 8);
        this.languageText.setFont(this.boldFont);
        this.languageText.setText("");
        this.languageText.setLayoutData((Object)new GridData(4, 2, true, false));
        IDEUtil.normalizeBackground((Control)this.languageText, (Control)typeComp);
        new Label(composite, 0).setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        this.manageRegistriesComp = new Composite(composite, 0);
        this.manageRegistriesComp.setLayout((Layout)new GridLayout(1, false));
        this.manageRegistriesComp.setLayoutData((Object)new GridData(1, 3, false, false, 2, 1));
        Link manageRegistriesLink = new Link(this.manageRegistriesComp, 0);
        manageRegistriesLink.setText(Messages.ManageRegistriesLinkLabel + " <a>" + Messages.ManageRegistriesLinkText + "</a>");
        manageRegistriesLink.setToolTipText(Messages.ManageRegistriesLinkTooltip);
        manageRegistriesLink.setLayoutData((Object)new GridData(1, 2, false, false));
        manageRegistriesLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                block5: {
                    try {
                        List regList = RegistryUtil.listRegistrySecrets((String)ProjectValidationPage.this.connection.getConid(), (IProgressMonitor)new NullProgressMonitor());
                        ImagePushRegistryInfo pushReg = ProjectValidationPage.this.connection.requestGetPushRegistry();
                        final RegistryManagementDialog regDialog = new RegistryManagementDialog(ProjectValidationPage.this.getShell(), ProjectValidationPage.this.connection, regList, pushReg);
                        if (regDialog.open() != 0 || !regDialog.hasChanges()) break block5;
                        IRunnableWithProgress runnable = new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                                SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.RegUpdateTask, (int)100);
                                IStatus status = regDialog.updateRegistries((IProgressMonitor)mon.split(75));
                                if (!status.isOK()) {
                                    throw new InvocationTargetException(status.getException(), status.getMessage());
                                }
                                if (mon.isCanceled()) {
                                    return;
                                }
                            }
                        };
                        try {
                            ProjectValidationPage.this.getWizard().getContainer().run(true, true, runnable);
                        }
                        catch (InvocationTargetException e) {
                            MessageDialog.openError((Shell)ProjectValidationPage.this.getShell(), (String)Messages.RegUpdateErrorTitle, (String)e.getMessage());
                            return;
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                    catch (Exception e) {
                        MessageDialog.openError((Shell)ProjectValidationPage.this.getShell(), (String)Messages.RegListErrorTitle, (String)NLS.bind((String)Messages.RegListErrorMsg, (Object)e));
                    }
                }
            }
        });
        this.updatePage(false);
        this.setControl((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), CodewindUIPlugin.MAIN_CONTEXTID);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.validateMsg.setFocus();
        }
    }

    public void dispose() {
        if (this.boldFont != null) {
            this.boldFont.dispose();
        }
        super.dispose();
    }

    public boolean canFlipToNextPage() {
        return this.canFinish();
    }

    public boolean canFinish() {
        return this.projectInfo != null;
    }

    public boolean isActivePage() {
        return this.isCurrentPage();
    }

    public ProjectInfo getProjectInfo() {
        return this.projectInfo;
    }

    public void setConnection(CodewindConnection connection) {
        this.connection = connection;
        this.updatePage(true);
    }

    public void setProject(IProject project, IPath projectPath) {
        this.project = project;
        this.projectPath = projectPath;
        this.updatePage(true);
    }

    private void updatePage(boolean fromPrevPage) {
        if (this.connection == null || this.projectPath == null) {
            return;
        }
        this.projectInfo = null;
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.ProjectValidationTask, (Object)ProjectValidationPage.this.getProjectName()), (int)100);
                ProjectValidationPage.this.projectInfo = ProjectValidationPage.this.getProjectInfo((IProgressMonitor)mon.split(100));
            }
        };
        try {
            if (fromPrevPage && this.getWizard() != null && this.getWizard().getContainer() != null) {
                this.getContainer().run(true, true, runnable);
            } else {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
            }
        }
        catch (InvocationTargetException e) {
            Logger.logError((String)("An error occurred getting the project info for the project at: " + this.projectPath.toOSString()), (Throwable)e);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (this.projectInfo != null) {
            this.validateMsg.setText(NLS.bind((String)Messages.ProjectValidationPageMsg, (Object)this.getProjectName()));
            this.typeText.setText(this.projectInfo.type.getDisplayName());
            IDEUtil.normalizeBackground((Control)this.typeText, (Control)this.typeText.getParent());
            this.typeLabel.setVisible(true);
            this.typeText.setVisible(true);
            if (!this.projectInfo.language.isUnknown()) {
                this.languageText.setText(this.projectInfo.language.getDisplayName());
                IDEUtil.normalizeBackground((Control)this.languageText, (Control)this.languageText.getParent());
                this.languageLabel.setVisible(true);
                this.languageText.setVisible(true);
            } else {
                this.languageLabel.setVisible(false);
                this.languageText.setVisible(false);
            }
        } else {
            this.validateMsg.setText(Messages.ProjectValidationPageFailMsg);
            this.typeLabel.setVisible(false);
            this.typeText.setVisible(false);
            this.languageLabel.setVisible(false);
            this.languageText.setVisible(false);
        }
        int width = this.validateMsg.getParent().getClientArea().width;
        this.validateMsg.setSize(width, this.validateMsg.computeSize((int)width, (int)-1).y);
    }

    private ProjectInfo getProjectInfo(IProgressMonitor monitor) {
        if (this.connection == null || this.projectPath == null) {
            return null;
        }
        try {
            return ProjectUtil.validateProject((String)this.getProjectName(), (String)this.projectPath.toFile().getAbsolutePath(), null, (String)this.connection.getConid(), (IProgressMonitor)monitor);
        }
        catch (Exception e) {
            Logger.logError((String)("An error occurred trying to get the project type for the project at: " + this.projectPath.toOSString()), (Throwable)e);
            return null;
        }
    }

    private String getProjectName() {
        return this.project != null ? this.project.getName() : this.projectPath.lastSegment();
    }
}

