/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.filewatchers.core;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.codewind.filewatchers.core.FWLogger;
import org.eclipse.codewind.filewatchers.core.ProjectToWatch;

public class PathFilter {
    private static final FWLogger log = FWLogger.getInstance();
    private final List<Pattern> filenameExcludePatterns = new ArrayList<Pattern>();
    private final List<Pattern> pathExcludePatterns = new ArrayList<Pattern>();

    public PathFilter(ProjectToWatch ptw) {
        if (ptw.getIgnoredFilenames() != null) {
            ptw.getIgnoredFilenames().forEach(e -> {
                if (e.contains("/") || e.contains("\\")) {
                    log.logSevere("Ignored filenames may not contain path separators: " + e);
                    return;
                }
                String text = e.replace("*", ".*");
                this.filenameExcludePatterns.add(Pattern.compile(text));
            });
        }
        if (ptw.getIgnoredPaths() != null) {
            ptw.getIgnoredPaths().forEach(e -> {
                if (e.contains("\\")) {
                    log.logSevere("Ignore paths may not contain Windows-style path separators: " + e);
                    return;
                }
                String text = e.replace("*", ".*");
                this.pathExcludePatterns.add(Pattern.compile(text));
            });
        }
    }

    public boolean isFilteredOutByFilename(String path) {
        if (path.contains("\\")) {
            log.logSevere("Parameter cannot contain Window-style file paths");
            return false;
        }
        for (String name : path.split("/")) {
            for (Pattern p : this.filenameExcludePatterns) {
                if (!p.matcher(name).matches()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isFilteredOutByPath(String path) {
        if (path.contains("\\")) {
            log.logSevere("Parameter cannot contain Window-style file paths");
            return false;
        }
        for (Pattern p : this.pathExcludePatterns) {
            if (!p.matcher(path).matches()) continue;
            return true;
        }
        return false;
    }
}

