/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.connection;

import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.connection.JSONObjectResult;
import org.json.JSONException;
import org.json.JSONObject;

public class ExtensionConfig
extends JSONObjectResult {
    private static final String EXTENSION_KEY = "extension";
    private static final String CONFIG_KEY = "config";
    private static final String CONTAINER_APP_ROOT_KEY = "containerAppRoot";

    public ExtensionConfig(JSONObject extensionConfig) {
        super(extensionConfig, "extension config");
    }

    public static ExtensionConfig getExtensionConfig(JSONObject projectInfo) {
        try {
            JSONObject ext;
            if (projectInfo.has(EXTENSION_KEY) && !projectInfo.isNull(EXTENSION_KEY) && (ext = projectInfo.getJSONObject(EXTENSION_KEY)).has(CONFIG_KEY) && !ext.isNull(CONFIG_KEY)) {
                return new ExtensionConfig(ext.getJSONObject(CONFIG_KEY));
            }
        }
        catch (JSONException e) {
            Logger.logError("The project info format is not valid", e);
        }
        return null;
    }

    public String getContainerAppRoot() {
        return this.getString(CONTAINER_APP_ROOT_KEY);
    }
}

