/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.cli;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.JSONObjectResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ProjectLinks {
    private List<LinkInfo> links = new ArrayList<LinkInfo>();

    public ProjectLinks(JSONArray linksArray) throws JSONException {
        for (int i = 0; i < linksArray.length(); ++i) {
            this.links.add(new LinkInfo(linksArray.getJSONObject(i)));
        }
    }

    public List<LinkInfo> getLinks() {
        return Collections.unmodifiableList(this.links);
    }

    public List<LinkInfo> getLinkedProjects(String projectId) {
        return this.links.stream().filter(link -> link.getProjectId().equals(projectId)).collect(Collectors.toList());
    }

    public List<LinkInfo> getBrokenLinks(CodewindConnection conn) {
        return this.links.stream().filter(link -> conn.getAppByID(link.getProjectId()) == null).collect(Collectors.toList());
    }

    public class LinkInfo
    extends JSONObjectResult {
        private static final String PROJECT_ID_KEY = "projectID";
        private static final String ENV_NAME_KEY = "envName";
        private static final String PROJECT_URL_KEY = "projectURL";
        private static final String PROJECT_NAME_KEY = "projectName";

        public LinkInfo(JSONObject linkInfo) {
            super(linkInfo, "link info");
        }

        public String getProjectId() {
            return this.getString(PROJECT_ID_KEY);
        }

        public String getEnvVar() {
            return this.getString(ENV_NAME_KEY);
        }

        public String getProjectURL() {
            return this.getString(PROJECT_URL_KEY);
        }

        public String getProjectName() {
            return this.getString(PROJECT_NAME_KEY);
        }
    }
}

