/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.prefs;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Arrays;
import java.util.Base64;
import org.eclipse.codewind.core.internal.HttpUtil;
import org.eclipse.codewind.core.internal.IAuthInfo;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.IDEUtil;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.wizards.CompositeContainer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class TemplateSourceAuthComposite
extends Composite {
    private CompositeContainer container;
    private Button logonButton;
    private Button tokenButton;
    private Button testButton;
    private boolean isLogonMethod;
    private Composite logonComposite;
    private Composite tokenComposite;
    private Text usernameText;
    private Text passwordText;
    private Text tokenText;
    private String usernameValue;
    private String passwordValue;
    private String tokenValue;
    private URI uri;

    protected TemplateSourceAuthComposite(Composite parent, CompositeContainer container, boolean isLogonMethod, String username) {
        super(parent, 0);
        this.container = container;
        this.isLogonMethod = isLogonMethod;
        this.usernameValue = username;
        this.createControl();
    }

    protected void createControl() {
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 15;
        this.setLayout((Layout)layout);
        Group authGroup = new Group((Composite)this, 0);
        authGroup.setText("Authentication method");
        layout = new GridLayout();
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 15;
        layout.marginHeight = 15;
        authGroup.setLayout((Layout)layout);
        authGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.logonButton = new Button((Composite)authGroup, 16);
        this.logonButton.setText(Messages.AddRepoDialogLogonAuthButton);
        this.logonButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.logonButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateSourceAuthComposite.this.setEnablement(TemplateSourceAuthComposite.this.logonButton.getSelection());
                TemplateSourceAuthComposite.this.validate();
            }
        });
        this.logonComposite = this.createSubComposite((Composite)authGroup, 2);
        Label label = new Label(this.logonComposite, 0);
        label.setText(Messages.AddRepoDialogUsernameLabel);
        label.setLayoutData((Object)new GridData(4, 4, false, false));
        this.usernameText = new Text(this.logonComposite, 2048);
        this.usernameText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.usernameText.addModifyListener(event -> this.validate());
        label = new Label(this.logonComposite, 0);
        label.setText(Messages.AddRepoDialogPasswordLabel);
        label.setLayoutData((Object)new GridData(4, 4, false, false));
        this.passwordText = new Text(this.logonComposite, 0x400800);
        this.passwordText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.passwordText.addModifyListener(event -> this.validate());
        this.tokenButton = new Button((Composite)authGroup, 16);
        this.tokenButton.setText(Messages.AddRepoDialogAccessTokenAuthButton);
        this.tokenButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.tokenButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateSourceAuthComposite.this.setEnablement(!TemplateSourceAuthComposite.this.tokenButton.getSelection());
                TemplateSourceAuthComposite.this.validate();
            }
        });
        this.tokenComposite = this.createSubComposite((Composite)authGroup, 2);
        label = new Label(this.tokenComposite, 0);
        label.setText(Messages.AddRepoDialogAccessTokenLabel);
        label.setLayoutData((Object)new GridData(4, 4, false, false));
        this.tokenText = new Text(this.tokenComposite, 0x400800);
        this.tokenText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.tokenText.addModifyListener(event -> this.validate());
        this.testButton = new Button((Composite)this, 8);
        this.testButton.setText(Messages.AddRepoDialogAuthTestButtonLabel);
        this.testButton.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.testButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.AddRepoDialogAuthTestTaskLabel, (Object)TemplateSourceAuthComposite.this.uri), (int)-1);
                            HttpUtil.HttpResult result = HttpUtil.get((URI)TemplateSourceAuthComposite.this.uri, (IAuthInfo)TemplateSourceAuthComposite.this.getAuthInfo());
                            if (!result.isGoodResponse) {
                                String errorMsg = result.error;
                                if (errorMsg == null || errorMsg.trim().isEmpty()) {
                                    errorMsg = NLS.bind((String)Messages.AddRepoDialogAuthTestFailedDefaultMsg, (Object)result.responseCode);
                                }
                                throw new InvocationTargetException(new IOException(errorMsg));
                            }
                        }
                        catch (IOException e) {
                            throw new InvocationTargetException(e, e.toString());
                        }
                    }
                };
                try {
                    TemplateSourceAuthComposite.this.container.run(runnable);
                    TemplateSourceAuthComposite.this.container.setErrorMessage(null);
                    TemplateSourceAuthComposite.this.container.setMessage(Messages.AddRepoDialogAuthTestSuccessMsg);
                }
                catch (Exception e) {
                    String msg = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getCause().toString() : e.toString();
                    IDEUtil.openInfoDialog(Messages.AddRepoDialogAuthTestFailedTitle, NLS.bind((String)Messages.AddRepoDialogAuthTestFailedError, (Object)TemplateSourceAuthComposite.this.uri, (Object)msg));
                    TemplateSourceAuthComposite.this.container.setErrorMessage(Messages.AddRepoDialogAuthTestFailedMsg);
                }
            }
        });
        this.testButton.setEnabled(false);
        this.logonButton.setSelection(this.isLogonMethod);
        this.tokenButton.setSelection(!this.isLogonMethod);
        if (this.isLogonMethod && this.usernameValue != null) {
            this.usernameText.setText(this.usernameValue);
        }
        this.setEnablement(this.isLogonMethod);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this, CodewindUIPlugin.MAIN_CONTEXTID);
    }

    protected Composite createSubComposite(Composite parent, int numColumn) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumn;
        layout.marginHeight = 2;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 15;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        return composite;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.logonButton.getSelection()) {
                this.usernameText.setFocus();
            } else {
                this.tokenText.setFocus();
            }
        }
    }

    void updatePage(URI uri) {
        this.uri = uri;
    }

    private void setEnablement(boolean isLogonMethod) {
        Arrays.stream(this.logonComposite.getChildren()).forEach(c -> c.setEnabled(isLogonMethod));
        Arrays.stream(this.tokenComposite.getChildren()).forEach(c -> c.setEnabled(!isLogonMethod));
    }

    private void validate() {
        String errorMsg = null;
        this.isLogonMethod = this.logonButton.getSelection();
        if (this.isLogonMethod) {
            this.usernameValue = IDEUtil.getTextValue(this.usernameText);
            this.passwordValue = IDEUtil.getTextValue(this.passwordText);
            if (this.usernameValue == null) {
                errorMsg = Messages.AddRepoDialogNoUsername;
            } else if (this.passwordValue == null) {
                errorMsg = Messages.AddRepoDialogNoPassword;
            }
        } else {
            this.tokenValue = IDEUtil.getTextValue(this.tokenText);
            if (this.tokenValue == null) {
                errorMsg = Messages.AddRepoDialogNoAccessToken;
            }
        }
        this.container.setMessage(null);
        this.container.setErrorMessage(errorMsg);
        this.testButton.setEnabled(errorMsg == null);
        this.container.update();
    }

    boolean canFinish() {
        if (this.isLogonMethod) {
            return this.usernameValue != null && this.passwordValue != null;
        }
        return this.tokenValue != null;
    }

    boolean isLogonMethod() {
        return this.isLogonMethod;
    }

    String getUsername() {
        return this.usernameValue;
    }

    String getPassword() {
        return this.passwordValue;
    }

    String getToken() {
        return this.tokenValue;
    }

    IAuthInfo getAuthInfo() {
        return this.isLogonMethod ? new LogonAuth(this.usernameValue, this.passwordValue) : new TokenAuth(this.tokenValue);
    }

    public static class TokenAuth
    implements IAuthInfo {
        private final String token;

        public TokenAuth(String token) {
            this.token = token;
        }

        public boolean isValid() {
            return this.token != null;
        }

        public String getHttpAuthorization() {
            return "bearer " + this.token;
        }
    }

    public static class LogonAuth
    implements IAuthInfo {
        private final String username;
        private final String password;

        public LogonAuth(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public boolean isValid() {
            return this.username != null && this.password != null;
        }

        public String getHttpAuthorization() {
            try {
                String auth = this.username + ":" + this.password;
                return "Basic " + Base64.getEncoder().encodeToString(auth.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                Logger.logError((String)"An unsupported encoding exception occurred trying to encode the logon authentication.");
                return null;
            }
        }
    }
}

