/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.cli;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.cli.InstallUtil;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class InstallStatus {
    public static final String STATUS_KEY = "status";
    public static final String URL_KEY = "url";
    public static final String INSTALLED_VERSIONS_KEY = "installed-versions";
    public static final String STARTED_KEY = "started";
    public static final String WS_UPGRADE_VERSION = "0.6.0";
    public static final InstallStatus UNKNOWN = new InstallStatus(Status.UNKNOWN);
    private Status status;
    private String url;
    private JSONArray installedVersions;
    private JSONArray startedVersions;
    private String supportedVersion;

    public InstallStatus(JSONObject statusObj) {
        try {
            this.status = Status.getStatus(statusObj.getString(STATUS_KEY));
            if (this.status == Status.STARTED) {
                this.startedVersions = statusObj.getJSONArray(STARTED_KEY);
                this.supportedVersion = this.getSupportedVersion(this.startedVersions);
                this.url = statusObj.getString(URL_KEY);
                if (!this.url.endsWith("/")) {
                    this.url = this.url + "/";
                }
            }
            if (this.status.isInstalled()) {
                this.installedVersions = statusObj.getJSONArray(INSTALLED_VERSIONS_KEY);
                if (this.supportedVersion == null) {
                    this.supportedVersion = this.getSupportedVersion(this.installedVersions);
                }
                if (this.installedVersions.length() == 0 && this.startedVersions != null) {
                    this.installedVersions = this.startedVersions;
                }
            }
        }
        catch (JSONException e) {
            Logger.logError("The Codewind installer status format is not recognized", e);
            this.status = Status.UNKNOWN;
            this.url = null;
        }
    }

    private String getSupportedVersion(JSONArray versions) throws JSONException {
        String requestedVersion = InstallUtil.getRequestedVersion();
        for (int i = 0; i < versions.length(); ++i) {
            String version = versions.getString(i);
            if (!CodewindConnection.isSupportedVersion(version) || requestedVersion != null && !requestedVersion.equals(version)) continue;
            return version;
        }
        return null;
    }

    private InstallStatus(Status status) {
        this.status = status;
    }

    public boolean isUnknown() {
        return this.status == Status.UNKNOWN;
    }

    public boolean isInstalled() {
        return this.supportedVersion != null;
    }

    public boolean isStarted() {
        try {
            if (this.supportedVersion != null && this.status == Status.STARTED) {
                for (int i = 0; i < this.startedVersions.length(); ++i) {
                    if (!this.supportedVersion.equals(this.startedVersions.getString(i))) continue;
                    return true;
                }
            }
        }
        catch (JSONException e) {
            Logger.logError("The Codewind installer status format is not recognized", e);
        }
        return false;
    }

    public String getVersion() {
        return this.supportedVersion;
    }

    public String getURL() {
        return this.url;
    }

    public boolean hasInstalledVersions() {
        return this.installedVersions != null && this.installedVersions.length() > 0;
    }

    public boolean hasStartedVersions() {
        return this.startedVersions != null && this.startedVersions.length() > 0;
    }

    public List<String> getInstalledVersions() {
        return this.getVersionList(this.installedVersions);
    }

    public String getInstalledVersionsString() {
        return this.getVersionString(this.installedVersions);
    }

    public String getStartedVersionsString() {
        return this.getVersionString(this.startedVersions);
    }

    public boolean requiresWSUpgrade() {
        JSONArray versions;
        JSONArray jSONArray = versions = this.startedVersions != null && this.startedVersions.length() > 0 ? this.startedVersions : this.installedVersions;
        if (versions == null || versions.length() == 0) {
            return false;
        }
        String highestVersion = null;
        for (int i = 0; i < versions.length(); ++i) {
            try {
                String version = versions.getString(i);
                if (highestVersion != null && CodewindConnection.compareVersions(version, highestVersion) <= 0) continue;
                highestVersion = version;
                continue;
            }
            catch (JSONException e) {
                Logger.logError("The Codewind installer status format is not recognized", e);
            }
        }
        return CodewindConnection.compareVersions(highestVersion, WS_UPGRADE_VERSION) < 0;
    }

    private List<String> getVersionList(JSONArray versions) {
        ArrayList<String> versionList = new ArrayList<String>();
        for (int i = 0; i < versions.length(); ++i) {
            try {
                versionList.add(versions.getString(i));
                continue;
            }
            catch (JSONException e) {
                Logger.logError("The Codewind installer status format is not recognized", e);
            }
        }
        return versionList;
    }

    private String getVersionString(JSONArray versions) {
        List<String> versionList = this.getVersionList(versions);
        return CoreUtil.formatString(versionList.toArray(new String[versionList.size()]), ", ");
    }

    private static enum Status {
        UNINSTALLED("uninstalled"),
        STOPPED("stopped"),
        STARTED("started"),
        UNKNOWN("unknown");

        private String value;

        private Status(String value) {
            this.value = value;
        }

        public static Status getStatus(String statusStr) {
            for (Status status : Status.values()) {
                if (!status.value.equals(statusStr)) continue;
                return status;
            }
            Logger.logError("Unrecognized installer status: " + statusStr);
            return UNKNOWN;
        }

        public boolean isInstalled() {
            return this != UNINSTALLED && this != UNKNOWN;
        }
    }
}

