/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.cli;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.eclipse.codewind.core.internal.ProcessHelper;
import org.eclipse.codewind.core.internal.cli.CLIUtil;
import org.eclipse.codewind.core.internal.connection.RegistryInfo;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.json.JSONArray;
import org.json.JSONException;

public class RegistryUtil {
    private static final String REGISTRYSECRETS_CMD = "registrysecrets";
    private static final String[] REG_SECRET_LIST_CMD = new String[]{"registrysecrets", "list"};
    private static final String[] REG_SECRET_ADD_CMD = new String[]{"registrysecrets", "add"};
    private static final String[] REG_SECRET_REMOVE_CMD = new String[]{"registrysecrets", "remove"};
    private static final String ADDRESS_OPTION = "--address";
    private static final String USERNAME_OPTION = "--username";
    private static final String PASSWORD_OPTION = "--password";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<RegistryInfo> listRegistrySecrets(String conid, IProgressMonitor monitor) throws IOException, JSONException, TimeoutException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Process process = null;
        try {
            process = CLIUtil.runCWCTL(CLIUtil.GLOBAL_JSON_INSECURE, REG_SECRET_LIST_CMD, new String[]{"--conid", conid});
            ProcessHelper.ProcessResult result = ProcessHelper.waitForProcess(process, 500, 60, (IProgressMonitor)mon.split(100));
            CLIUtil.checkResult(REG_SECRET_LIST_CMD, result, true);
            JSONArray registryArray = new JSONArray(result.getOutput().trim());
            ArrayList<RegistryInfo> registries = new ArrayList<RegistryInfo>();
            for (int i = 0; i < registryArray.length(); ++i) {
                registries.add(new RegistryInfo(registryArray.getJSONObject(i)));
            }
            ArrayList<RegistryInfo> arrayList = registries;
            return arrayList;
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
        }
    }

    public static void addRegistrySecret(String address, String username, String password, String conid, IProgressMonitor monitor) throws IOException, JSONException, TimeoutException {
        RegistryUtil.runRegistrySecretCmd(REG_SECRET_ADD_CMD, new String[]{ADDRESS_OPTION, address, USERNAME_OPTION, username, PASSWORD_OPTION, password, "--conid", conid}, null, monitor);
    }

    public static void removeRegistrySecret(String address, String conid, IProgressMonitor monitor) throws IOException, JSONException, TimeoutException {
        RegistryUtil.runRegistrySecretCmd(REG_SECRET_REMOVE_CMD, new String[]{ADDRESS_OPTION, address, "--conid", conid}, null, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runRegistrySecretCmd(String[] command, String[] options, String[] args, IProgressMonitor monitor) throws IOException, JSONException, TimeoutException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Process process = null;
        try {
            process = CLIUtil.runCWCTL(CLIUtil.GLOBAL_JSON_INSECURE, command, options, args);
            ProcessHelper.ProcessResult result = ProcessHelper.waitForProcess(process, 500, 60, (IProgressMonitor)mon.split(100));
            CLIUtil.checkResult(command, result, false);
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
        }
    }
}

