/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.wizards.CodewindConnectionComposite;
import org.eclipse.codewind.ui.internal.wizards.CompositeContainer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class EditConnectionDialog
extends TitleAreaDialog
implements CompositeContainer {
    private final CodewindConnection connection;
    private CodewindConnectionComposite connectionComp;
    private ProgressMonitorPart progressMon;

    public EditConnectionDialog(Shell parentShell, CodewindConnection connection) {
        super(parentShell);
        this.connection = connection;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.EditConnectionDialogShell);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitleImage(CodewindUIPlugin.getImage("codewindBanner.png"));
        this.setTitle(Messages.EditConnectionDialogTitle);
        this.setMessage(NLS.bind((String)Messages.EditConnectionDialogMessage, (Object)this.connection.getName()));
        Composite content = (Composite)super.createDialogArea(parent);
        content.setLayout((Layout)new GridLayout(1, false));
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        this.connectionComp = new CodewindConnectionComposite(content, this, this.connection);
        this.connectionComp.setLayoutData(new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 10;
        layout.marginWidth = 20;
        this.progressMon = new ProgressMonitorPart(parent, (Layout)layout, true);
        this.progressMon.setLayoutData((Object)new GridData(768));
        this.progressMon.setVisible(false);
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    protected void okPressed() {
        super.okPressed();
        Job job = new Job(NLS.bind((String)Messages.UpdateConnectionJobLabel, (Object)this.connectionComp.getConnectionName())){

            protected IStatus run(IProgressMonitor monitor) {
                return EditConnectionDialog.this.connectionComp.updateConnection(monitor);
            }
        };
        job.schedule();
    }

    @Override
    public void validate() {
        this.connectionComp.validate();
        this.getButton(0).setEnabled(this.connectionComp.canFinish());
    }

    @Override
    public void run(IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        this.progressMon.setVisible(true);
        try {
            ModalContext.run((IRunnableWithProgress)runnable, (boolean)true, (IProgressMonitor)this.progressMon, (Display)this.getShell().getDisplay());
        }
        finally {
            this.progressMon.done();
            this.progressMon.setVisible(false);
        }
    }

    protected Point getInitialSize() {
        Point point = super.getInitialSize();
        return new Point(650, point.y);
    }
}

