/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import org.eclipse.codewind.core.internal.CodewindEclipseApplication;
import org.eclipse.codewind.core.internal.console.ProjectLogInfo;
import org.eclipse.codewind.ui.internal.actions.AttachDebuggerAction;
import org.eclipse.codewind.ui.internal.actions.ContainerShellAction;
import org.eclipse.codewind.ui.internal.actions.EnableDisableAutoBuildAction;
import org.eclipse.codewind.ui.internal.actions.EnableDisableInjectMetricsAction;
import org.eclipse.codewind.ui.internal.actions.EnableDisableProjectAction;
import org.eclipse.codewind.ui.internal.actions.HideAllLogsAction;
import org.eclipse.codewind.ui.internal.actions.ImportProjectAction;
import org.eclipse.codewind.ui.internal.actions.LogFileAction;
import org.eclipse.codewind.ui.internal.actions.OpenAppAction;
import org.eclipse.codewind.ui.internal.actions.OpenAppMonitorAction;
import org.eclipse.codewind.ui.internal.actions.OpenAppOverviewAction;
import org.eclipse.codewind.ui.internal.actions.OpenPerfMonitorAction;
import org.eclipse.codewind.ui.internal.actions.RestartDebugModeAction;
import org.eclipse.codewind.ui.internal.actions.RestartRunModeAction;
import org.eclipse.codewind.ui.internal.actions.ShowAllLogsAction;
import org.eclipse.codewind.ui.internal.actions.StartBuildAction;
import org.eclipse.codewind.ui.internal.actions.UnbindProjectAction;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;

public class CodewindApplicationActionProvider
extends CommonActionProvider {
    private ISelectionProvider selProvider;
    private RestartRunModeAction restartRunAction;
    private RestartDebugModeAction restartDebugAction;
    private AttachDebuggerAction attachDebuggerAction;
    private OpenAppMonitorAction openAppMonitorAction;
    private OpenPerfMonitorAction openPerfMonitorAction;
    private ContainerShellAction containerShellAction;
    private EnableDisableAutoBuildAction enableDisableAutoBuildAction;
    private EnableDisableInjectMetricsAction enableDisableInjectMetricsAction;
    private EnableDisableProjectAction enableDisableProjectAction;
    private UnbindProjectAction unbindProjectAction;
    private OpenAppAction openAppAction;
    private OpenAppOverviewAction openAppOverviewAction;
    private ImportProjectAction importProjectAction;
    private ShowAllLogsAction showAllLogsAction;
    private HideAllLogsAction hideAllLogsAction;
    private StartBuildAction startBuildAction;
    private OpenAppDoubleClickAction openAppDoubleClickAction;

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        this.selProvider = aSite.getStructuredViewer();
        this.restartRunAction = new RestartRunModeAction(this.selProvider);
        this.restartDebugAction = new RestartDebugModeAction(this.selProvider);
        this.attachDebuggerAction = new AttachDebuggerAction(this.selProvider);
        this.openAppMonitorAction = new OpenAppMonitorAction(this.selProvider);
        this.openPerfMonitorAction = new OpenPerfMonitorAction(this.selProvider);
        this.containerShellAction = new ContainerShellAction(this.selProvider);
        this.enableDisableAutoBuildAction = new EnableDisableAutoBuildAction(this.selProvider);
        this.enableDisableInjectMetricsAction = new EnableDisableInjectMetricsAction(this.selProvider);
        this.enableDisableProjectAction = new EnableDisableProjectAction(this.selProvider);
        this.unbindProjectAction = new UnbindProjectAction(this.selProvider);
        this.openAppAction = new OpenAppAction(this.selProvider);
        this.openAppOverviewAction = new OpenAppOverviewAction(this.selProvider);
        this.showAllLogsAction = new ShowAllLogsAction();
        this.hideAllLogsAction = new HideAllLogsAction();
        this.importProjectAction = new ImportProjectAction(this.selProvider);
        this.startBuildAction = new StartBuildAction(this.selProvider);
        this.openAppDoubleClickAction = new OpenAppDoubleClickAction(this.selProvider);
    }

    public void fillContextMenu(IMenuManager menu) {
        this.selProvider.setSelection(this.selProvider.getSelection());
        menu.add((IAction)this.openAppAction);
        menu.add((IAction)this.openAppOverviewAction);
        if (this.containerShellAction.showAction()) {
            menu.add((IAction)this.containerShellAction);
        }
        menu.add((IContributionItem)new Separator());
        int numItems = menu.getItems().length;
        if (this.openAppMonitorAction.showAction()) {
            menu.add((IAction)this.openAppMonitorAction);
        }
        if (this.openPerfMonitorAction.showAction()) {
            menu.add((IAction)this.openPerfMonitorAction);
        }
        if (this.enableDisableInjectMetricsAction.showAction()) {
            menu.add((IAction)this.enableDisableInjectMetricsAction);
        }
        if (menu.getItems().length > numItems) {
            menu.add((IContributionItem)new Separator());
        }
        menu.add((IAction)this.importProjectAction);
        this.addLogFileSubMenu(menu);
        menu.add((IContributionItem)new Separator());
        numItems = menu.getItems().length;
        if (this.restartRunAction.showAction()) {
            menu.add((IAction)this.restartRunAction);
        }
        if (this.restartDebugAction.showAction()) {
            menu.add((IAction)this.restartDebugAction);
        }
        if (this.attachDebuggerAction.showAction()) {
            menu.add((IAction)this.attachDebuggerAction);
        }
        if (menu.getItems().length > numItems) {
            menu.add((IContributionItem)new Separator());
        }
        menu.add((IAction)this.startBuildAction);
        menu.add((IAction)this.enableDisableAutoBuildAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.enableDisableProjectAction);
        menu.add((IAction)this.unbindProjectAction);
    }

    private void addLogFileSubMenu(IMenuManager menu) {
        CodewindEclipseApplication app;
        Object obj;
        ICommonViewerSite viewSite = this.getActionSite().getViewSite();
        ISelection selection = viewSite.getSelectionProvider().getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection sel = (IStructuredSelection)selection;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof CodewindEclipseApplication && (app = (CodewindEclipseApplication)obj).isAvailable() && app.getLogInfos() != null && !app.getLogInfos().isEmpty()) {
            MenuManager menuMgr = new MenuManager(Messages.ShowLogFilesMenu, "ShowLogFiles");
            this.showAllLogsAction.setApp(app);
            menuMgr.add((IAction)this.showAllLogsAction);
            this.hideAllLogsAction.setApp(app);
            menuMgr.add((IAction)this.hideAllLogsAction);
            menuMgr.add((IContributionItem)new Separator());
            for (ProjectLogInfo logInfo : app.getLogInfos()) {
                menuMgr.add((IAction)new LogFileAction(app, logInfo, viewSite));
            }
            menu.add((IContributionItem)menuMgr);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.openAppDoubleClickAction);
    }

    private static class OpenAppDoubleClickAction
    extends SelectionProviderAction {
        private final OpenAppAction actionDelegate;

        public OpenAppDoubleClickAction(ISelectionProvider selectionProvider) {
            super(selectionProvider, "");
            this.actionDelegate = new OpenAppAction(selectionProvider);
            this.selectionChanged(this.getStructuredSelection());
        }

        public void selectionChanged(IStructuredSelection sel) {
            this.actionDelegate.selectionChanged(sel);
        }

        public void run() {
            this.actionDelegate.run();
        }
    }
}

