/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.cli;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.ProcessHelper;
import org.eclipse.codewind.core.internal.cli.CLIUtil;
import org.eclipse.codewind.core.internal.cli.LogLevels;
import org.eclipse.codewind.core.internal.messages.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.osgi.util.NLS;
import org.json.JSONException;
import org.json.JSONObject;

public class OtherUtil {
    private static final String[] LOGLEVELS_CMD = new String[]{"loglevels"};
    private static final String[] DIAGNOSTICS_CMD = new String[]{"mustgather"};
    private static final String ECLIPSE_WORKSPACE_OPTION = "--eclipseWorkspaceDir";
    private static final String PROJECTS_OPTION = "--projects";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogLevels getLoglevels(String connectionName, String conid, IProgressMonitor monitor) throws IOException, JSONException, TimeoutException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.FetchLogLevelsTaskLabel, (Object)connectionName), (int)100);
        Process process = null;
        try {
            process = CLIUtil.runCWCTL(CLIUtil.GLOBAL_JSON_INSECURE, LOGLEVELS_CMD, new String[]{"--conid", conid});
            ProcessHelper.ProcessResult result = ProcessHelper.waitForProcess(process, 500, 300, (IProgressMonitor)mon);
            CLIUtil.checkResult(LOGLEVELS_CMD, result, true);
            JSONObject resultJson = new JSONObject(result.getOutput());
            LogLevels logLevels = new LogLevels(resultJson);
            return logLevels;
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLoglevels(String connectionName, String level, String conid, IProgressMonitor monitor) throws IOException, JSONException, TimeoutException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.SetLogLevelTaskLabel, (Object[])new String[]{connectionName, level}), (int)100);
        Process process = null;
        try {
            process = CLIUtil.runCWCTL(CLIUtil.GLOBAL_JSON_INSECURE, LOGLEVELS_CMD, new String[]{"--conid", conid}, new String[]{level});
            ProcessHelper.ProcessResult result = ProcessHelper.waitForProcess(process, 500, 300, (IProgressMonitor)mon);
            CLIUtil.checkResult(LOGLEVELS_CMD, result, true);
            JSONObject resultJson = new JSONObject(result.getOutput());
            LogLevels logLevels = new LogLevels(resultJson);
            if (!logLevels.getCurrentLevel().equals(level)) {
                String msg = "The current log level is not what was requested, requested: " + level + ", actual: " + logLevels.getCurrentLevel();
                Logger.logError(msg);
                throw new IOException(msg);
            }
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
        }
    }

    public static void startDiagnostics(String connectionName, String conid, boolean includeEclipseWorkspace, boolean includeProjectInfo) throws IOException, CoreException {
        ArrayList<String> options = new ArrayList<String>();
        options.add("--conid");
        options.add(conid);
        if (includeEclipseWorkspace) {
            options.add(ECLIPSE_WORKSPACE_OPTION);
            options.add(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString());
        }
        if (includeProjectInfo) {
            options.add(PROJECTS_OPTION);
        }
        List<String> command = CLIUtil.getCWCTLCommandList(null, DIAGNOSTICS_CMD, options.toArray(new String[options.size()]), null);
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType("org.eclipse.codewind.core.internal.utilityLaunchConfigurationType");
        ILaunchConfigurationWorkingCopy workingCopy = launchConfigurationType.newInstance((IContainer)null, connectionName);
        workingCopy.setAttribute("org.eclipse.codewind.core.internal.titleAttr", "Generate diagnostics");
        workingCopy.setAttribute("org.eclipse.codewind.core.internal.commandAttr", command);
        ILaunchConfiguration launchConfig = workingCopy.doSave();
        launchConfig.launch("run", (IProgressMonitor)new NullProgressMonitor());
    }
}

