/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import java.util.Optional;
import org.eclipse.codewind.core.CodewindCorePlugin;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.cli.OtherUtil;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.ui.internal.IDEUtil;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.wizards.DiagnosticsDialog;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleView;

public class DiagnosticsAction
extends SelectionProviderAction {
    private CodewindConnection conn;

    public DiagnosticsAction(ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.DiagnosticsActionLabel);
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        Object obj;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof CodewindConnection) {
            this.conn = (CodewindConnection)obj;
            this.setEnabled(this.conn.isConnected());
            return;
        }
        this.setEnabled(false);
    }

    public void run() {
        if (this.conn == null) {
            Logger.logError((String)"DiagnosticsAction ran but no connection was selected");
            return;
        }
        DiagnosticsDialog dialog = new DiagnosticsDialog(Display.getDefault().getActiveShell(), this.conn);
        if (dialog.open() == 0) {
            try {
                ILaunch launch = OtherUtil.startDiagnostics((String)this.conn.getName(), (String)this.conn.getConid(), (boolean)dialog.includeEclipseWorkspace(), (boolean)dialog.includeProjectInfo());
                Optional<IConsole> console = IDEUtil.getConsoleForLaunch(launch);
                if (console.isPresent()) {
                    IWorkbenchPage page;
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    IWorkbenchPage iWorkbenchPage = page = window == null ? null : window.getActivePage();
                    if (page != null) {
                        try {
                            IConsoleView view = (IConsoleView)page.showView("org.eclipse.ui.console.ConsoleView");
                            view.display(console.get());
                        }
                        catch (Exception e) {
                            Logger.logError((String)"An error occurred trying to open the console view", (Throwable)e);
                        }
                    }
                } else {
                    Logger.logError((String)("Could not find the console for launch: " + launch));
                }
            }
            catch (Exception e) {
                Logger.logError((String)("An error occurred trying to generate diagnostics for connection: " + this.conn.getName()), (Throwable)e);
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.DiagnosticsErrorTitle, (String)NLS.bind((String)Messages.DiagnosticsErrorMsg, (Object)this.conn.getName(), (Object)e.getLocalizedMessage()));
            }
        }
    }

    public boolean showAction() {
        return this.conn != null && this.conn.isLocal() && CodewindCorePlugin.getDefault().getPreferenceStore().getBoolean("enableSupportFeatures");
    }
}

