/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.prefs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.codewind.core.CodewindCorePlugin;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.actions.CodewindInstall;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.internal.browser.BrowserManager;
import org.eclipse.ui.internal.browser.IBrowserDescriptor;

public class CodewindPrefsParentPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "CodewindParentPage";
    private static IPreferenceStore prefs;
    private Button autoOpenOverviewButton;
    private Button supportFeaturesButton;
    private Text installTimeoutText;
    private Text uninstallTimeoutText;
    private Text startTimeoutText;
    private Text stopTimeoutText;
    private Text debugTimeoutText;
    private Combo webBrowserCombo;
    private Button[] stopAppsButtons = new Button[3];
    private String browserName = null;

    public void init(IWorkbench arg0) {
        this.setImageDescriptor(CodewindUIPlugin.getDefaultIcon());
        prefs = CodewindCorePlugin.getDefault().getPreferenceStore();
    }

    protected Control createContents(Composite parent) {
        final Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(3);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        if (CodewindInstall.ENABLE_STOP_APPS_OPTION) {
            Text stopAppContainersLabel = new Text(composite, 12);
            stopAppContainersLabel.setText(Messages.PrefsParentPage_StopAppsLabel);
            stopAppContainersLabel.setLayoutData((Object)new GridData(1, 4, false, false, 2, 1));
            stopAppContainersLabel.setBackground(composite.getBackground());
            stopAppContainersLabel.setForeground(composite.getForeground());
            Composite stopAppsComposite = new Composite(composite, 0);
            layout = new GridLayout();
            layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(8);
            layout.verticalSpacing = this.convertVerticalDLUsToPixels(3);
            layout.marginWidth = 20;
            layout.marginHeight = 2;
            layout.numColumns = 3;
            stopAppsComposite.setLayout((Layout)layout);
            stopAppsComposite.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            this.stopAppsButtons[0] = new Button(stopAppsComposite, 16);
            this.stopAppsButtons[0].setText(Messages.PrefsParentPage_StopAppsAlways);
            this.stopAppsButtons[0].setData((Object)"stopAppContainersAlways");
            this.stopAppsButtons[1] = new Button(stopAppsComposite, 16);
            this.stopAppsButtons[1].setText(Messages.PrefsParentPage_StopAppsNever);
            this.stopAppsButtons[1].setData((Object)"stopAppContainersNever");
            this.stopAppsButtons[2] = new Button(stopAppsComposite, 16);
            this.stopAppsButtons[2].setText(Messages.PrefsParentPage_StopAppsPrompt);
            this.stopAppsButtons[2].setData((Object)"stopAppContainersPrompt");
            this.setStopAppsSelection(prefs.getString("stopAppContainers"));
            new Label(composite, 256).setLayoutData((Object)new GridData(768, 2, true, false, 2, 1));
        }
        Group generalGroup = new Group(composite, 0);
        generalGroup.setText(Messages.PrefsParentPage_GeneralGroup);
        layout = new GridLayout();
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(5);
        layout.marginWidth = 3;
        layout.marginHeight = 10;
        layout.numColumns = 1;
        generalGroup.setLayout((Layout)layout);
        generalGroup.setLayoutData((Object)new GridData(272));
        this.autoOpenOverviewButton = new Button((Composite)generalGroup, 32);
        this.autoOpenOverviewButton.setText(Messages.PrefsParentPage_AutoOpenOverviewButton);
        this.autoOpenOverviewButton.setLayoutData((Object)new GridData(1, 4, false, false));
        this.autoOpenOverviewButton.setSelection(prefs.getBoolean("autoOpenOverviewPage"));
        this.supportFeaturesButton = new Button((Composite)generalGroup, 32);
        this.supportFeaturesButton.setText(Messages.PrefsParentPage_EnableSupportFeatures);
        this.supportFeaturesButton.setLayoutData((Object)new GridData(1, 4, false, false));
        this.supportFeaturesButton.setSelection(prefs.getBoolean("enableSupportFeatures"));
        Group installGroup = new Group(composite, 0);
        installGroup.setText(Messages.PrefsParentPage_StartupShutdownGroup);
        layout = new GridLayout();
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(5);
        layout.marginWidth = 3;
        layout.marginHeight = 10;
        layout.numColumns = 4;
        installGroup.setLayout((Layout)layout);
        installGroup.setLayoutData((Object)new GridData(272));
        this.installTimeoutText = this.createCWTimeoutEntry((Composite)installGroup, Messages.PrefsParentPage_InstallTimeout, "cwInstallTimeout");
        this.uninstallTimeoutText = this.createCWTimeoutEntry((Composite)installGroup, Messages.PrefsParentPage_UninstallTimeout, "cwUninstallTimeout");
        this.startTimeoutText = this.createCWTimeoutEntry((Composite)installGroup, Messages.PrefsParentPage_StartTimeout, "cwStartTimeout");
        this.stopTimeoutText = this.createCWTimeoutEntry((Composite)installGroup, Messages.PrefsParentPage_StopTimeout, "cwStopTimeout");
        Group debugGroup = new Group(composite, 0);
        debugGroup.setText(Messages.PrefsParentPage_DebugGroup);
        layout = new GridLayout();
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(5);
        layout.marginWidth = 3;
        layout.marginHeight = 10;
        layout.numColumns = 2;
        debugGroup.setLayout((Layout)layout);
        debugGroup.setLayoutData((Object)new GridData(272));
        Label debugTimeoutLabel = new Label((Composite)debugGroup, 8);
        debugTimeoutLabel.setText(" " + Messages.PrefsParentPage_DebugTimeoutLabel);
        debugTimeoutLabel.setLayoutData((Object)new GridData(1, 4, false, false));
        this.debugTimeoutText = new Text((Composite)debugGroup, 2048);
        this.debugTimeoutText.setTextLimit(3);
        this.debugTimeoutText.setText("" + prefs.getInt("serverDebugTimeout"));
        GridData debugTextData = new GridData(1, 4, false, false);
        debugTextData.widthHint = 50;
        this.debugTimeoutText.setLayoutData((Object)debugTextData);
        this.debugTimeoutText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                CodewindPrefsParentPage.this.validate();
            }
        });
        Composite selectWebBrowserComposite = new Composite((Composite)debugGroup, 0);
        layout = new GridLayout();
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(3);
        layout.marginWidth = 3;
        layout.marginHeight = 2;
        layout.numColumns = 2;
        selectWebBrowserComposite.setLayout((Layout)layout);
        selectWebBrowserComposite.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Label browserSelectionLabel = new Label(selectWebBrowserComposite, 0);
        browserSelectionLabel.setText(Messages.BrowserSelectionLabel);
        browserSelectionLabel.setLayoutData((Object)new GridData(1, 4, false, false, 2, 1));
        this.webBrowserCombo = new Combo(selectWebBrowserComposite, 2056);
        this.refreshPreferencesPage();
        Link addBrowserButton = new Link(selectWebBrowserComposite, 0);
        addBrowserButton.setText("<a href=\"org.eclipse.ui.browser.preferencePage\">" + Messages.BrowserSelectionManageButtonText + "</a>");
        addBrowserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)composite.getShell(), (String)e.text, null, null);
                composite.layout();
            }
        });
        Label endSpacer = new Label(composite, 0);
        endSpacer.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        new Label(composite, 0);
        return composite;
    }

    private Text createCWTimeoutEntry(Composite comp, String label, String prefKey) {
        Label timeoutLabel = new Label(comp, 0);
        timeoutLabel.setText(label);
        timeoutLabel.setLayoutData((Object)new GridData(1, 4, false, false));
        Text text = new Text(comp, 2048);
        text.setText(Integer.toString(prefs.getInt(prefKey)));
        GridData data = new GridData(1, 4, false, false);
        data.widthHint = 50;
        text.setLayoutData((Object)data);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                CodewindPrefsParentPage.this.validate();
            }
        });
        return text;
    }

    private void setStopAppsSelection(String selection) {
        for (Button button : this.stopAppsButtons) {
            if (!button.getData().equals(selection)) continue;
            button.setSelection(true);
            break;
        }
    }

    private void validate() {
        if (!(this.validateTimeout(this.installTimeoutText.getText().trim()) && this.validateTimeout(this.uninstallTimeoutText.getText().trim()) && this.validateTimeout(this.startTimeoutText.getText().trim()) && this.validateTimeout(this.stopTimeoutText.getText().trim()) && this.validateTimeout(this.debugTimeoutText.getText().trim()))) {
            return;
        }
        this.setErrorMessage(null);
        this.setValid(true);
    }

    private boolean validateTimeout(String timeoutStr) {
        boolean isValid = true;
        try {
            int timeout = Integer.parseInt(timeoutStr);
            if (timeout <= 0) {
                isValid = false;
            }
        }
        catch (NumberFormatException e) {
            isValid = false;
        }
        if (!isValid) {
            this.setErrorMessage(NLS.bind((String)Messages.PrefsParentPage_ErrInvalidTimeout, (Object)timeoutStr));
            this.setValid(false);
        }
        return isValid;
    }

    public boolean performOk() {
        if (!this.isValid()) {
            return false;
        }
        if (CodewindInstall.ENABLE_STOP_APPS_OPTION) {
            for (Button button : this.stopAppsButtons) {
                if (!button.getSelection()) continue;
                prefs.setValue("stopAppContainers", (String)button.getData());
                break;
            }
        }
        prefs.setValue("autoOpenOverviewPage", this.autoOpenOverviewButton.getSelection());
        prefs.setValue("enableSupportFeatures", this.supportFeaturesButton.getSelection());
        prefs.setValue("cwInstallTimeout", Integer.parseInt(this.installTimeoutText.getText().trim()));
        prefs.setValue("cwUninstallTimeout", Integer.parseInt(this.uninstallTimeoutText.getText().trim()));
        prefs.setValue("cwStartTimeout", Integer.parseInt(this.startTimeoutText.getText().trim()));
        prefs.setValue("cwStopTimeout", Integer.parseInt(this.stopTimeoutText.getText().trim()));
        int debugTimeout = Integer.parseInt(this.debugTimeoutText.getText().trim());
        prefs.setValue("serverDebugTimeout", debugTimeout);
        this.debugTimeoutText.setText("" + debugTimeout);
        if (this.webBrowserCombo != null) {
            if (this.webBrowserCombo.getSelectionIndex() > 0) {
                if (this.browserName != null) {
                    prefs.setValue("nodejsDebugBrowserName", this.browserName);
                }
            } else {
                prefs.setToDefault("nodejsDebugBrowserName");
            }
        }
        return true;
    }

    public void performDefaults() {
        if (CodewindInstall.ENABLE_STOP_APPS_OPTION) {
            this.setStopAppsSelection(prefs.getDefaultString("stopAppContainers"));
        }
        this.autoOpenOverviewButton.setSelection(prefs.getDefaultBoolean("autoOpenOverviewPage"));
        this.supportFeaturesButton.setSelection(prefs.getDefaultBoolean("enableSupportFeatures"));
        this.installTimeoutText.setText(Integer.toString(prefs.getDefaultInt("cwInstallTimeout")));
        this.uninstallTimeoutText.setText(Integer.toString(prefs.getDefaultInt("cwUninstallTimeout")));
        this.startTimeoutText.setText(Integer.toString(prefs.getDefaultInt("cwStartTimeout")));
        this.stopTimeoutText.setText(Integer.toString(prefs.getDefaultInt("cwStopTimeout")));
        this.debugTimeoutText.setText("" + prefs.getDefaultInt("serverDebugTimeout"));
        this.webBrowserCombo.select(0);
    }

    protected void refreshPreferencesPage() {
        List browserList;
        if (this.webBrowserCombo == null) {
            return;
        }
        this.webBrowserCombo.removeAll();
        this.webBrowserCombo.add(Messages.BrowserSelectionNoBrowserSelected);
        this.webBrowserCombo.select(0);
        BrowserManager bm = BrowserManager.getInstance();
        if (bm != null && (browserList = bm.getWebBrowsers()) != null) {
            ArrayList<IBrowserDescriptor> validBrowsers = new ArrayList<IBrowserDescriptor>();
            int len = browserList.size();
            for (int i = 0; i < len; ++i) {
                IBrowserDescriptor tempBrowser = (IBrowserDescriptor)browserList.get(i);
                if (tempBrowser == null || tempBrowser.getLocation() == null || tempBrowser.getLocation().trim().equals("")) continue;
                validBrowsers.add(tempBrowser);
            }
            len = validBrowsers.size();
            Logger.log((String)("Refresh preference page valid browser length: " + len));
            String foundDefaultBrowser = prefs.getString("nodejsDebugBrowserName");
            boolean foundDefaultBrowserName = false;
            for (int i = 0; i < len; ++i) {
                IBrowserDescriptor tempBrowser = (IBrowserDescriptor)validBrowsers.get(i);
                if (tempBrowser == null) continue;
                String browserName = tempBrowser.getName();
                this.webBrowserCombo.add(browserName);
                if (browserName == null || foundDefaultBrowser == null || !browserName.equalsIgnoreCase(foundDefaultBrowser)) continue;
                this.webBrowserCombo.select(i + 1);
                foundDefaultBrowserName = true;
            }
            Logger.log((String)("Refresh preference page found default browser: " + foundDefaultBrowser));
            if (foundDefaultBrowser == null || !foundDefaultBrowserName) {
                Logger.log((String)"Refresh preference page: could not find preferences or browser was removed");
                prefs.setToDefault("nodejsDebugBrowserName");
            }
            this.webBrowserCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (CodewindPrefsParentPage.this.webBrowserCombo.getSelectionIndex() >= 0) {
                        CodewindPrefsParentPage.this.browserName = CodewindPrefsParentPage.this.webBrowserCombo.getText();
                    }
                }
            });
        }
        this.webBrowserCombo.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    public void setVisible(boolean visible) {
        if (this.webBrowserCombo != null) {
            this.refreshPreferencesPage();
        }
        super.setVisible(visible);
    }
}

