/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.IDEUtil;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class DiagnosticsDialog
extends TitleAreaDialog {
    private final CodewindConnection conn;
    private boolean includeEclipseWorkspace;
    private boolean includeProjectInfo;
    private Button eclipseWorkspaceButton;
    private Button projectInfoButton;
    private List<Button> includeButtons = new ArrayList<Button>();
    private Button selectAllButton;
    private Button clearAllButton;

    public DiagnosticsDialog(Shell parentShell, CodewindConnection conn) {
        super(parentShell);
        this.conn = conn;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Collect Diagnostics");
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitleImage(CodewindUIPlugin.getImage("codewindBanner.png"));
        this.setTitle("Collect Diagnostics for Connection: " + this.conn.getName());
        this.setMessage("Identify additional information to include in the diagnostics");
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 11;
        layout.marginWidth = 9;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 15;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.widthHint = 200;
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        Text text = new Text(composite, 64);
        text.setText("Some information such as Codewind logs are included in the diagnostics by default. Select any additional information to include in the diagnostics below.");
        text.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        IDEUtil.normalizeBackground((Control)text, (Control)composite);
        Group group = new Group(composite, 0);
        group.setText("Additional diagnostic information");
        layout = new GridLayout();
        layout.marginHeight = 11;
        layout.marginWidth = 9;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 7;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        this.eclipseWorkspaceButton = new Button((Composite)group, 32);
        this.eclipseWorkspaceButton.setText("Eclipse workspace log");
        this.includeButtons.add(this.eclipseWorkspaceButton);
        this.projectInfoButton = new Button((Composite)group, 32);
        this.projectInfoButton.setText("Project information");
        this.includeButtons.add(this.projectInfoButton);
        Composite buttonComposite = new Composite(composite, 0);
        layout = new GridLayout();
        layout.marginHeight = 11;
        layout.marginWidth = 9;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 7;
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)new GridData(4, 0x1000008, false, false));
        this.selectAllButton = new Button(buttonComposite, 8);
        this.selectAllButton.setText("Select all");
        this.selectAllButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.clearAllButton = new Button(buttonComposite, 8);
        this.clearAllButton.setText("Clear all");
        this.clearAllButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.eclipseWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiagnosticsDialog.this.updateSelectButtons();
            }
        });
        this.projectInfoButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiagnosticsDialog.this.updateSelectButtons();
            }
        });
        this.selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiagnosticsDialog.this.includeButtons.stream().forEach(button -> button.setSelection(true));
                DiagnosticsDialog.this.updateSelectButtons();
            }
        });
        this.clearAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiagnosticsDialog.this.includeButtons.stream().forEach(button -> button.setSelection(false));
                DiagnosticsDialog.this.updateSelectButtons();
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, CodewindUIPlugin.MAIN_CONTEXTID);
        this.includeButtons.stream().forEach(button -> button.setSelection(false));
        this.updateSelectButtons();
        return composite;
    }

    private void updateSelectButtons() {
        this.selectAllButton.setEnabled(this.includeButtons.stream().filter(button -> !button.getSelection()).findFirst().isPresent());
        this.clearAllButton.setEnabled(this.includeButtons.stream().filter(button -> button.getSelection()).findFirst().isPresent());
    }

    protected void okPressed() {
        this.includeEclipseWorkspace = this.eclipseWorkspaceButton.getSelection();
        this.includeProjectInfo = this.projectInfoButton.getSelection();
        super.okPressed();
    }

    protected Point getInitialSize() {
        Point point = super.getInitialSize();
        return new Point(750, point.y);
    }

    public boolean includeEclipseWorkspace() {
        return this.includeEclipseWorkspace;
    }

    public boolean includeProjectInfo() {
        return this.includeProjectInfo;
    }
}

