/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import org.eclipse.codewind.core.CodewindCorePlugin;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.cli.OtherUtil;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.ui.internal.wizards.DiagnosticsDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionProviderAction;

public class DiagnosticsAction
extends SelectionProviderAction {
    private CodewindConnection conn;

    public DiagnosticsAction(ISelectionProvider selectionProvider) {
        super(selectionProvider, "Collect Diagnostics");
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        Object obj;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof CodewindConnection) {
            this.conn = (CodewindConnection)obj;
            this.setEnabled(this.conn.isConnected());
            return;
        }
        this.setEnabled(false);
    }

    public void run() {
        if (this.conn == null) {
            Logger.logError((String)"DiagnosticsAction ran but no connection was selected");
            return;
        }
        DiagnosticsDialog dialog = new DiagnosticsDialog(Display.getDefault().getActiveShell(), this.conn);
        if (dialog.open() == 0) {
            try {
                OtherUtil.startDiagnostics((String)this.conn.getName(), (String)this.conn.getConid(), (boolean)dialog.includeEclipseWorkspace(), (boolean)dialog.includeProjectInfo());
            }
            catch (Exception e) {
                Logger.logError((String)("An error occurred trying to generate diagnostics for connection: " + this.conn.getName()), (Throwable)e);
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Diagnostics Generation Error", (String)("An error occurred trying to generate diagnostics for the " + this.conn.getName() + " connection: " + e.getLocalizedMessage()));
            }
        }
    }

    public boolean showAction() {
        return this.conn != null && this.conn.isLocal() && CodewindCorePlugin.getDefault().getPreferenceStore().getBoolean("enableSupportFeatures");
    }
}

