/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.connection;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.cli.AuthToken;
import org.eclipse.codewind.core.internal.cli.AuthUtil;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.filewatchers.core.FWAuthToken;
import org.eclipse.codewind.filewatchers.core.IAuthTokenProvider;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.json.JSONException;

public class AuthManager
implements IAuthTokenProvider {
    private final CodewindConnection connection;
    private AuthToken token;

    AuthManager(CodewindConnection connection, AuthToken token) {
        this.connection = connection;
        this.token = token;
    }

    AuthToken getToken(boolean update, IProgressMonitor monitor) throws IOException, JSONException {
        boolean needsUpdate;
        boolean bl = needsUpdate = this.token == null || this.token.aboutToExpire() || update;
        if (needsUpdate) {
            this.updateToken(monitor);
        }
        return this.token;
    }

    synchronized void setToken(AuthToken token) {
        this.token = token;
    }

    synchronized void updateToken(IProgressMonitor monitor) throws IOException, JSONException {
        if (this.token != null && this.token.recentlyCreated()) {
            return;
        }
        try {
            this.token = AuthUtil.getAuthToken(this.connection.getUsername(), this.connection.getConid(), monitor);
        }
        catch (TimeoutException e) {
            throw new IOException("Timed out trying to update the token for connection: " + this.connection.getName());
        }
    }

    AuthToken getTokenNonBlocking() {
        return this.token;
    }

    void updateTokenNonBlocking() {
        Runnable runnable = () -> {
            try {
                this.updateToken((IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                Logger.logError("An error occurred trying to update the token for connection: " + this.connection.getName(), e);
            }
        };
        Thread thread = new Thread(runnable);
        thread.setDaemon(true);
        thread.run();
    }

    public FWAuthToken getLatestAuthToken() {
        AuthToken token = this.getTokenNonBlocking();
        if (token != null && token.getToken() != null && token.getTokenType() != null) {
            return new FWAuthToken(token.getToken(), token.getTokenType());
        }
        return null;
    }

    public void informReceivedInvalidAuthToken(FWAuthToken badToken) {
        this.updateTokenNonBlocking();
    }
}

