/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.cli;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.codewind.core.CodewindCorePlugin;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.FileUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.PlatformUtil;
import org.eclipse.codewind.core.internal.ProcessHelper;
import org.eclipse.codewind.core.internal.cli.CLIInfo;
import org.eclipse.codewind.core.internal.cli.InstallUtil;
import org.eclipse.core.runtime.IPath;
import org.json.JSONException;
import org.json.JSONObject;

public class CLIUtil {
    public static final String CODEWIND_STORE_DIR = ".codewind";
    public static final String JSON_OPTION = "--json";
    public static final String INSECURE_OPTION = "--insecure";
    public static final String[] GLOBAL_JSON = new String[]{"--json"};
    public static final String[] GLOBAL_INSECURE = new String[]{"--insecure"};
    public static final String[] GLOBAL_JSON_INSECURE = new String[]{"--json", "--insecure"};
    public static final String CON_ID_OPTION = "--conid";
    public static final String ERROR_KEY = "error";
    public static final String ERROR_DESCRIPTION_KEY = "error_description";
    private static final String INSTALLER_DIR = "installerWorkDir";
    private static final Map<PlatformUtil.OperatingSystem, String> cwctlMap = new HashMap<PlatformUtil.OperatingSystem, String>();
    private static final Map<PlatformUtil.OperatingSystem, String> appsodyMap = new HashMap<PlatformUtil.OperatingSystem, String>();
    private static final CLIInfo codewindInfo;
    private static final CLIInfo appsodyInfo;
    private static final CLIInfo[] cliInfos;

    public static Process runCWCTL(String[] globalOptions, String[] cmd, String[] options) throws IOException {
        return CLIUtil.runCWCTL(globalOptions, cmd, options, null);
    }

    public static Process runCWCTL(String[] globalOptions, String[] cmd, String[] options, String[] args) throws IOException {
        String[] command = CLIUtil.getCWCTLCommand(globalOptions, cmd, options, args);
        ProcessBuilder builder = new ProcessBuilder(command);
        if (PlatformUtil.getOS() == PlatformUtil.OperatingSystem.MAC) {
            String pathVar = System.getenv("PATH");
            pathVar = "/usr/local/bin:" + pathVar;
            Map<String, String> env = builder.environment();
            env.put("PATH", pathVar);
        }
        return builder.start();
    }

    public static List<String> getCWCTLCommandList(String[] globalOptions, String[] cmd, String[] options, String[] args) throws IOException {
        for (int i = 0; i < cliInfos.length; ++i) {
            if (cliInfos[i] == null) continue;
            cliInfos[i].setInstallPath(CLIUtil.getCLIExecutable(cliInfos[i]));
        }
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(codewindInfo.getInstallPath());
        CLIUtil.addOptions(cmdList, globalOptions);
        CLIUtil.addOptions(cmdList, cmd);
        CLIUtil.addOptions(cmdList, options);
        CLIUtil.addOptions(cmdList, args);
        return cmdList;
    }

    public static String[] getCWCTLCommand(String[] globalOptions, String[] cmd, String[] options, String[] args) throws IOException {
        List<String> cmdList = CLIUtil.getCWCTLCommandList(globalOptions, cmd, options, args);
        return cmdList.toArray(new String[cmdList.size()]);
    }

    private static void addOptions(List<String> cmdList, String[] options) {
        if (options != null) {
            for (String opt : options) {
                cmdList.add(opt);
            }
        }
    }

    public static String getCWCTLExecutable() throws IOException {
        return CLIUtil.getCLIExecutable(codewindInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCLIExecutable(CLIInfo operation) throws IOException {
        String installPath = operation.getInstallPath();
        if (installPath != null && new File(installPath).exists()) {
            return installPath;
        }
        PlatformUtil.OperatingSystem os = PlatformUtil.getOS(System.getProperty("os.name"));
        Map<PlatformUtil.OperatingSystem, String> osPathMap = operation.getOSPathMap();
        if (osPathMap == null) {
            String msg = "Failed to get the list of operating specific paths for installing the executable " + operation.getInstallName();
            Logger.logError(msg);
            throw new IOException(msg);
        }
        String relPath = osPathMap.get((Object)os);
        if (relPath == null) {
            String msg = "Failed to get the relative path for the install executable " + operation.getInstallName();
            Logger.logError(msg);
            throw new IOException(msg);
        }
        String installerDir = CLIUtil.getCLIInstallDir();
        String execName = relPath.substring(relPath.lastIndexOf(47) + 1);
        String execPath = installerDir + File.separator + execName;
        if (!FileUtil.makeDir(installerDir)) {
            String msg = "Failed to make the directory for the installer utility: " + installerDir;
            Logger.logError(msg);
            throw new IOException(msg);
        }
        InputStream stream = null;
        try {
            URL url = CodewindCorePlugin.getDefault().getBundle().getEntry(relPath);
            stream = url.openStream();
            FileUtil.copyFile(stream, execPath);
            if (PlatformUtil.getOS() != PlatformUtil.OperatingSystem.WINDOWS) {
                Set<PosixFilePermission> permissions = PosixFilePermissions.fromString("rwxr-xr-x");
                File file = new File(execPath);
                Files.setPosixFilePermissions(file.toPath(), permissions);
            }
            String string = execPath;
            return string;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static String getCLIInstallDir() {
        IPath userHome = CoreUtil.getUserHome();
        if (userHome != null) {
            return userHome.append(CODEWIND_STORE_DIR).append(InstallUtil.getDefaultInstallVersion()).toOSString();
        }
        IPath stateLoc = CodewindCorePlugin.getDefault().getStateLocation();
        return stateLoc.append(INSTALLER_DIR).toOSString();
    }

    public static void checkResult(String[] command, ProcessHelper.ProcessResult result, boolean checkOutput) throws IOException {
        String msg;
        try {
            JSONObject obj;
            if (result.getOutput() != null && !result.getOutput().isEmpty() && (obj = new JSONObject(result.getOutput())).has(ERROR_KEY) && obj.has(ERROR_DESCRIPTION_KEY)) {
                String msg2 = String.format("The cwctl '%s' command failed with error: %s", CoreUtil.formatString(command, " "), obj.getString(ERROR_DESCRIPTION_KEY));
                Logger.logError(msg2);
                throw new IOException(obj.getString(ERROR_DESCRIPTION_KEY));
            }
        }
        catch (JSONException obj) {
            // empty catch block
        }
        if (result.getExitValue() != 0) {
            String error = result.getError() != null && !result.getError().isEmpty() ? result.getError() : result.getOutput();
            msg = error == null || error.isEmpty() ? String.format("The cwctl '%s' command exited with return code %d", CoreUtil.formatString(command, " "), result.getExitValue()) : String.format("The cwctl '%s' command exited with return code %d and error: %s", CoreUtil.formatString(command, " "), result.getExitValue(), error);
            Logger.logError(msg);
            throw new IOException(msg);
        }
        if (checkOutput && (result.getOutput() == null || result.getOutput().isEmpty())) {
            msg = String.format("The cwctl '%s' command exited with return code 0 but the output was empty", CoreUtil.formatString(command, " "));
            Logger.logError(msg);
            throw new IOException(msg);
        }
        Logger.log(String.format("Result of the cwctl '%s' command: \n%s", CoreUtil.formatString(command, " "), Optional.ofNullable(result.getOutput()).orElse("<empty>")));
    }

    static {
        cwctlMap.put(PlatformUtil.OperatingSystem.LINUX, "binaries/linux/cwctl");
        cwctlMap.put(PlatformUtil.OperatingSystem.MAC, "binaries/darwin/cwctl");
        cwctlMap.put(PlatformUtil.OperatingSystem.WINDOWS, "binaries/windows/cwctl.exe");
        appsodyMap.put(PlatformUtil.OperatingSystem.LINUX, "binaries/linux/appsody");
        appsodyMap.put(PlatformUtil.OperatingSystem.MAC, "binaries/darwin/appsody");
        appsodyMap.put(PlatformUtil.OperatingSystem.WINDOWS, "binaries/windows/appsody.exe");
        codewindInfo = new CLIInfo("Codewind", cwctlMap);
        appsodyInfo = new CLIInfo("Appsody", appsodyMap);
        cliInfos = new CLIInfo[]{codewindInfo, appsodyInfo};
    }
}

