/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import java.util.List;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.wizards.NewCodewindProjectWizard;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.SelectionProviderAction;

public class NewProjectAction
extends SelectionProviderAction {
    protected CodewindConnection connection;

    public NewProjectAction(ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.NewProjectAction_Label);
        this.setImageDescriptor(CodewindUIPlugin.getImageDescriptor("elcl16/add_project.png"));
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        Object obj;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof CodewindConnection) {
            this.connection = (CodewindConnection)obj;
            this.setEnabled(this.connection.isConnected());
            return;
        }
        this.setEnabled(false);
    }

    public void run() {
        if (this.connection == null) {
            Logger.logError((String)"NewProjectAction ran but no connection was selected");
            return;
        }
        NewProjectAction.openNewProjectWizard(this.connection);
    }

    public static void openNewProjectWizard(CodewindConnection connection) {
        try {
            NewCodewindProjectWizard wizard = new NewCodewindProjectWizard(connection);
            WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
            dialog.open();
        }
        catch (Exception e) {
            Logger.logError((String)("An error occurred opening the new project wizard for connection: " + connection.getBaseURI()), (Throwable)e);
        }
    }

    public static void openNewProjectWizard(List<CodewindConnection> connections) {
        try {
            NewCodewindProjectWizard wizard = new NewCodewindProjectWizard(connections);
            WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
            dialog.open();
        }
        catch (Exception e) {
            Logger.logError((String)"An error occurred opening the new project wizard", (Throwable)e);
        }
    }
}

