/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.constants;

import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.constants.StartMode;
import org.eclipse.codewind.core.internal.messages.Messages;

public enum AppStatus {
    STARTED("started", Messages.AppStatusStarted),
    STARTING("starting", Messages.AppStatusStarting),
    STOPPING("stopping", Messages.AppStatusStopping),
    STOPPED("stopped", Messages.AppStatusStopped),
    UNKNOWN("unknown", Messages.AppStatusUnknown);

    public final String appStatus;
    public final String displayString;

    private AppStatus(String appStatus, String displayString) {
        this.appStatus = appStatus;
        this.displayString = displayString;
    }

    public static AppStatus get(String appStatus) {
        for (AppStatus state : AppStatus.values()) {
            if (!state.appStatus.equals(appStatus)) continue;
            return state;
        }
        Logger.logError("Unrecognized application status: " + appStatus);
        return UNKNOWN;
    }

    public String getDisplayString(StartMode mode) {
        if (this == STARTED && StartMode.DEBUG_MODES.contains((Object)mode)) {
            return Messages.AppStatusDebugging;
        }
        return this.displayString;
    }
}

