/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.filewatchers.core.internal;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionSpec;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.eclipse.codewind.filewatchers.core.FWLogger;
import org.eclipse.codewind.filewatchers.core.Filewatcher;
import org.eclipse.codewind.filewatchers.core.FilewatcherUtils;
import org.eclipse.codewind.filewatchers.core.ProjectToWatch;
import org.eclipse.codewind.filewatchers.core.internal.AuthTokenWrapper;
import org.eclipse.codewind.filewatchers.core.internal.WSClientEndpoint;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WebSocketManagerThread
extends Thread {
    private final WSClientEndpoint endpoint;
    private final String wsUrl;
    private final Filewatcher watcher;
    private final AtomicBoolean disposed = new AtomicBoolean(false);
    private final FWLogger log = FWLogger.getInstance();
    private static final int SEND_KEEPALIVE_EVERY_X_SECONDS = 25;
    private final OkHttpClient okClient;
    private final AuthTokenWrapper authTokenWrapper;
    private final FilewatcherUtils.ExponentialBackoffUtil exponentialBackoffUtil_synch = new FilewatcherUtils.ExponentialBackoffUtil(50L, 4000L, 2.0f);
    private final AtomicInteger numberOfConsecutiveFailures = new AtomicInteger(0);
    private final List<WebSocket> activeWebSockets_synch = new ArrayList<WebSocket>();

    public WebSocketManagerThread(String wsUrl, Filewatcher watcher) {
        OkHttpClient client;
        SSLContext ctx;
        this.setDaemon(true);
        this.setName(WebSocketManagerThread.class.getName());
        this.endpoint = new WSClientEndpoint(this, wsUrl);
        this.wsUrl = wsUrl;
        this.watcher = watcher;
        this.authTokenWrapper = watcher.internal_getAuthTokenWrapper();
        X509TrustManager tm = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] xcs, String str) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] xcs, String str) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
        HostnameVerifier hostnameVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        try {
            ctx = SSLContext.getInstance("TLSv1.2");
            ctx.init(null, new TrustManager[]{tm}, new SecureRandom());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException(e);
        }
        OkHttpClient.Builder b = new OkHttpClient.Builder().connectionSpecs(Arrays.asList(ConnectionSpec.MODERN_TLS, ConnectionSpec.COMPATIBLE_TLS, ConnectionSpec.CLEARTEXT)).sslSocketFactory(ctx.getSocketFactory(), tm).hostnameVerifier(hostnameVerifier);
        this.okClient = client = b.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Long nextPingInNanos = null;
            this.log.logInfo("Web socket manager thread for '" + this.wsUrl + "' begun.");
            while (!this.disposed.get()) {
                block14: {
                    try {
                        List<WebSocket> list = this.activeWebSockets_synch;
                        synchronized (list) {
                            if (this.activeWebSockets_synch.size() == 0) {
                                this.establishOrReestablishConnection();
                            }
                        }
                        if (nextPingInNanos == null) {
                            nextPingInNanos = System.nanoTime() + TimeUnit.NANOSECONDS.convert(25L, TimeUnit.SECONDS);
                        }
                        if (nextPingInNanos == null || System.nanoTime() <= nextPingInNanos) break block14;
                        try {
                            for (WebSocket ws : this.activeWebSockets_synch) {
                                ws.send("{}");
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        nextPingInNanos = null;
                    }
                    catch (Throwable t) {
                        this.log.logSevere("Unexpected exception occurred.", t, null);
                    }
                }
                FilewatcherUtils.sleepIgnoreInterrupt(1000L);
            }
        }
        finally {
            this.log.logInfo("Web socket thread for '" + this.wsUrl + "' ended.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void informConnectionSuccess(WebSocket webSocket) {
        if (this.disposed.get()) {
            return;
        }
        this.log.logInfo("WebSocket successfully connected to:" + this.wsUrl);
        this.numberOfConsecutiveFailures.getAndSet(0);
        FilewatcherUtils.ExponentialBackoffUtil exponentialBackoffUtil = this.exponentialBackoffUtil_synch;
        synchronized (exponentialBackoffUtil) {
            this.exponentialBackoffUtil_synch.successReset();
        }
        this.watcher.refreshWatchStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void informConnectionClosedOrFailed(WebSocket ws) {
        ws.close(1000, "Ensure WebSocket resource is disposed.");
        Object object = this.activeWebSockets_synch;
        synchronized (object) {
            boolean wsFound = this.activeWebSockets_synch.remove(ws);
            if (!wsFound && !this.disposed.get()) {
                this.log.logError("Unable to locate WebSocket in active websockets.");
            }
        }
        if (this.disposed.get()) {
            return;
        }
        this.numberOfConsecutiveFailures.incrementAndGet();
        object = this.exponentialBackoffUtil_synch;
        synchronized (object) {
            this.exponentialBackoffUtil_synch.failIncrease();
        }
        this.watcher.refreshWatchStatus();
        this.log.logInfo("WebSocket failed to connect to '" + this.wsUrl + "', establishOrReestablishConnection to retry.");
        this.establishOrReestablishConnection();
    }

    public void dispose() {
        if (this.disposed.get()) {
            return;
        }
        this.disposed.set(true);
        this.log.logInfo("disposed() called in " + this.getClass().getSimpleName());
        FilewatcherUtils.newThread(() -> {
            List<WebSocket> list = this.activeWebSockets_synch;
            synchronized (list) {
                for (WebSocket curr : this.activeWebSockets_synch) {
                    try {
                        curr.close(1000, "Disposing of WebSocket.");
                    }
                    catch (Exception exception) {}
                }
            }
            this.okClient.dispatcher().executorService().shutdown();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void establishOrReestablishConnection() {
        if (this.disposed.get()) {
            return;
        }
        List<WebSocket> list = this.activeWebSockets_synch;
        synchronized (list) {
            if (this.activeWebSockets_synch.size() > 0) {
                return;
            }
            if (this.numberOfConsecutiveFailures.get() > 0) {
                this.exponentialBackoffUtil_synch.sleepIgnoreInterrupt();
            }
            this.log.logInfo("Attempting to establish connection to WebSocket, attempt #" + (this.numberOfConsecutiveFailures.get() + 1));
            String url = this.wsUrl + "/websockets/file-changes/v1";
            Request request = new Request.Builder().url(url).build();
            WebSocket ws = this.okClient.newWebSocket(request, (WebSocketListener)this.endpoint);
            this.activeWebSockets_synch.add(ws);
        }
    }

    void receiveMessage(String s) {
        if (this.disposed.get()) {
            return;
        }
        try {
            JSONObject jo = new JSONObject(s);
            String type = jo.getString("type");
            if (type.equals("debug")) {
                this.handleDebugMessage(jo);
                return;
            }
            this.log.logInfo("Received watch change message from WebSocket: " + s);
            JSONArray projects = jo.getJSONArray("projects");
            ArrayList<ProjectToWatch.ProjectToWatchFromWebSocket> ptwList = new ArrayList<ProjectToWatch.ProjectToWatchFromWebSocket>();
            for (int x = 0; x < projects.length(); ++x) {
                JSONObject projectToWatchJson = projects.getJSONObject(x);
                String changeType = projectToWatchJson.getString("changeType");
                ProjectToWatch.ProjectToWatchFromWebSocket ptw = new ProjectToWatch.ProjectToWatchFromWebSocket(projectToWatchJson, changeType);
                ptwList.add(ptw);
            }
            String projectList = ptwList.stream().map(e -> "[" + e.getProjectId() + " in " + e.getPathToMonitor() + "], ").reduce((a, b) -> a + b).get().trim();
            projectList = projectList.substring(0, projectList.length() - 1);
            this.log.logInfo("Watch list update received for { " + projectList + " }");
            this.watcher.internal_updateFileWatchStateFromWebSocket(ptwList);
        }
        catch (JSONException e2) {
            this.log.logSevere("Unexpected JSON exception when trying to parse message", e2, null);
        }
        catch (IOException e3) {
            this.log.logSevere("IOException from file watch state updater", e3, null);
        }
    }

    private void handleDebugMessage(JSONObject jsonObj) {
        try {
            String msg = jsonObj.getString("msg");
            this.log.logInfo("------------------------------------------------------------");
            this.log.logInfo("[Server-Debug] " + msg);
            this.log.logInfo("------------------------------------------------------------");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

