/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.RemoteConnection;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.actions.SelectionProviderAction;

public class ConnectDisconnectAction
extends SelectionProviderAction {
    protected RemoteConnection conn;

    public ConnectDisconnectAction(ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.DisconnectActionLabel);
        this.setImageDescriptor(CodewindUIPlugin.getImageDescriptor("elcl16/remote_connect.png"));
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        Object obj;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof RemoteConnection) {
            this.conn = (RemoteConnection)obj;
            if (this.conn.isConnected()) {
                this.setText(Messages.DisconnectActionLabel);
            } else {
                this.setText(Messages.ConnectActionLabel);
            }
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    public void run() {
        if (this.conn == null) {
            Logger.logError((String)"ConnectDisconnectAction ran but a remote connection was not selected");
            return;
        }
        if (this.conn.isConnected()) {
            Job job = new Job(NLS.bind((String)Messages.DisconnectJobLabel, (Object)this.conn.getBaseURI())){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        ConnectDisconnectAction.this.conn.disconnect();
                        CodewindUIPlugin.getUpdateHandler().updateConnection((CodewindConnection)ConnectDisconnectAction.this.conn);
                        return Status.OK_STATUS;
                    }
                    catch (Exception e) {
                        Logger.logError((String)("An error occurred disconnecting from: " + ConnectDisconnectAction.this.conn.getBaseURI()), (Throwable)e);
                        return new Status(4, "org.eclipse.codewind.ui", NLS.bind((String)Messages.DisconnectJobError, (Object)ConnectDisconnectAction.this.conn.getBaseURI()), (Throwable)e);
                    }
                }
            };
            job.schedule();
        } else {
            ConnectDisconnectAction.connectRemoteCodewind(this.conn);
        }
    }

    public static void connectRemoteCodewind(final RemoteConnection conn) {
        Job job = new Job(NLS.bind((String)Messages.ConnectJobLabel, (Object)conn.getBaseURI())){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    conn.connect(monitor);
                    CodewindUIPlugin.getUpdateHandler().updateConnection((CodewindConnection)conn);
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    Logger.logError((String)("An error occurred connecting to: " + conn.getBaseURI()), (Throwable)e);
                    return new Status(4, "org.eclipse.codewind.ui", NLS.bind((String)Messages.ConnectJobError, (Object)conn.getBaseURI()), (Throwable)e);
                }
            }
        };
        job.schedule();
    }
}

