/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.debug;

import java.net.URI;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.codewind.core.CodewindCorePlugin;
import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.HttpUtil;
import org.eclipse.codewind.core.internal.IDebugLauncher;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.ui.internal.debug.NodeJsBrowserDialog;
import org.eclipse.codewind.ui.internal.debug.WebBrowserSelectionDialog;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.browser.BrowserManager;
import org.eclipse.ui.internal.browser.IBrowserDescriptor;
import org.json.JSONArray;
import org.json.JSONObject;

public class NodeJSDebugLauncher
implements IDebugLauncher {
    private static final String DEBUG_INFO = "/json/list";
    private static final String DEVTOOLS_URL_FIELD = "devtoolsFrontendUrl";

    public IStatus launchDebugger(CodewindApplication app) {
        String urlString = null;
        Exception e = null;
        try {
            urlString = this.getDebugURL(app);
        }
        catch (Exception e1) {
            e = e1;
        }
        if (urlString == null) {
            Logger.logError((String)("Failed to get the debug URL for the " + app.name + " application."), (Throwable)e);
            return new Status(4, "org.eclipse.codewind.ui", NLS.bind((String)Messages.NodeJSDebugURLError, (Object)app.name), (Throwable)e);
        }
        return this.openNodeJSDebugger(urlString);
    }

    public boolean canAttachDebugger(CodewindApplication app) {
        String host = app.getDebugConnectHost();
        int debugPort = app.getDebugConnectPort();
        try {
            String url;
            String response;
            JSONArray array;
            JSONObject info;
            URI uri = new URI("http", null, host, debugPort, DEBUG_INFO, null, null);
            HttpUtil.HttpResult result = HttpUtil.get((URI)uri);
            if (result.isGoodResponse && (info = (array = new JSONArray(response = result.response)).getJSONObject(0)).has(DEVTOOLS_URL_FIELD) && (url = info.getString(DEVTOOLS_URL_FIELD)) != null && !url.isEmpty()) {
                return true;
            }
        }
        catch (Exception e) {
            Logger.log((String)("Failed to retrieve the debug information for the " + app.name + " app: " + e.getMessage()));
        }
        return false;
    }

    private String getDebugURL(CodewindApplication app) throws Exception {
        IPreferenceStore prefs = CodewindCorePlugin.getDefault().getPreferenceStore();
        int debugTimeout = prefs.getInt("serverDebugTimeout");
        String host = app.getDebugConnectHost();
        int debugPort = app.getDebugConnectPort();
        URI uri = new URI("http", null, host, debugPort, DEBUG_INFO, null, null);
        Exception e = null;
        HttpUtil.HttpResult result = null;
        for (int i = 0; i <= debugTimeout; ++i) {
            try {
                result = HttpUtil.get((URI)uri);
                if (result.isGoodResponse) {
                    String response = result.response;
                    JSONArray array = new JSONArray(response);
                    JSONObject info = array.getJSONObject(0);
                    String url = info.getString(DEVTOOLS_URL_FIELD);
                    int start = url.indexOf("ws=") + 3;
                    int end = url.indexOf("/", start);
                    String subString = url.substring(start, end);
                    url = url.replace(subString, host + ":" + Integer.toString(debugPort));
                    return url;
                }
            }
            catch (Exception e1) {
                e = e1;
            }
            if (i > debugTimeout) continue;
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (result != null && !result.isGoodResponse) {
            Logger.logError((String)("Error getting debug information for the " + app.name + " application. Error code: " + result.responseCode + ", error: " + result.error + "."));
        } else {
            Logger.logError((String)("An exception occurred trying to retrieve the debug information for the " + app.name + " application."), (Throwable)e);
        }
        if (e != null) {
            throw e;
        }
        return null;
    }

    private IStatus openNodeJSDebugger(String chromeDevToolsUrl) {
        IPreferenceStore prefs = CodewindCorePlugin.getDefault().getPreferenceStore();
        String browserName = prefs.getString("nodejsDebugBrowserName");
        if (browserName != null) {
            Logger.log((String)("Using the " + browserName + " browser from the preferences."));
            if (!this.foundValidBrowser(browserName)) {
                browserName = null;
            }
        }
        if (browserName == null) {
            final AtomicInteger returnCode = new AtomicInteger(0);
            final String[] result = new String[1];
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    WebBrowserSelectionDialog browserSelection = new WebBrowserSelectionDialog(Display.getDefault().getActiveShell(), Messages.BrowserSelectionTitle, null, Messages.BrowserSelectionDescription, 5, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                    browserSelection.create();
                    browserSelection.open();
                    returnCode.set(browserSelection.getReturnCode());
                    if (returnCode.get() == 0) {
                        result[0] = browserSelection.getBrowserName();
                        boolean isNodejsDefaultBrowserSet = browserSelection.isNodejsDefaultBrowserSet();
                        if (isNodejsDefaultBrowserSet && browserSelection.getBrowserName() != null) {
                            IPreferenceStore prefs = CodewindCorePlugin.getDefault().getPreferenceStore();
                            prefs.setValue("nodejsDebugBrowserName", browserSelection.getBrowserName());
                        }
                    }
                }
            });
            if (returnCode.get() == 0) {
                browserName = result[0];
            } else {
                return Status.CANCEL_STATUS;
            }
        }
        return this.openBrowserDialog(chromeDevToolsUrl, browserName);
    }

    private IStatus openBrowserDialog(final String chromeDevToolsUrl, final String browserName) {
        final AtomicInteger returnCode = new AtomicInteger(0);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                NodeJsBrowserDialog nodeDialog = new NodeJsBrowserDialog(Display.getDefault().getActiveShell(), Messages.NodeJSOpenBrowserTitle, null, Messages.NodeJSOpenBrowserDesc, 5, new String[]{IDialogConstants.OK_LABEL}, 0, chromeDevToolsUrl, browserName);
                nodeDialog.open();
                returnCode.set(nodeDialog.getReturnCode());
            }
        });
        if (returnCode.get() != 0) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    private boolean foundValidBrowser(String browserName) {
        List browserList;
        BrowserManager bm = BrowserManager.getInstance();
        if (bm != null && (browserList = bm.getWebBrowsers()) != null) {
            int len = browserList.size();
            for (int i = 0; i < len; ++i) {
                String name;
                IBrowserDescriptor tempBrowser = (IBrowserDescriptor)browserList.get(i);
                if (tempBrowser == null || tempBrowser.getLocation() == null || tempBrowser.getLocation().trim().equals("") || (name = tempBrowser.getName()) == null || !name.equalsIgnoreCase(browserName)) continue;
                return true;
            }
        }
        return false;
    }
}

