/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.connection;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.codewind.core.internal.CodewindManager;
import org.eclipse.codewind.core.internal.CodewindObjectFactory;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.cli.AuthToken;
import org.eclipse.codewind.core.internal.cli.AuthUtil;
import org.eclipse.codewind.core.internal.cli.ConnectionInfo;
import org.eclipse.codewind.core.internal.cli.ConnectionUtil;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.messages.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class CodewindConnectionManager {
    public static final String RESTORE_CONNECTIONS_FAMILY = "org.eclipse.codewind.core.restoreConnectionsFamily";
    private static CodewindConnectionManager instance;
    private List<CodewindConnection> connections = new ArrayList<CodewindConnection>();
    private CodewindConnection localConnection = null;

    private CodewindConnectionManager() {
        instance = this;
        this.restoreConnections();
    }

    private static CodewindConnectionManager instance() {
        if (instance == null) {
            instance = new CodewindConnectionManager();
        }
        return instance;
    }

    public static synchronized CodewindConnection getLocalConnection() {
        return CodewindConnectionManager.instance().localConnection;
    }

    public static synchronized void add(CodewindConnection connection) {
        if (connection == null) {
            Logger.logError("Null connection passed to be added");
            return;
        }
        CodewindConnectionManager.instance().connections.add(connection);
        Logger.log("Added a new connection: " + connection.getBaseURI());
    }

    public static synchronized List<CodewindConnection> activeConnections() {
        return Collections.unmodifiableList(CodewindConnectionManager.instance().connections);
    }

    public static synchronized CodewindConnection getActiveConnection(String baseUrl) {
        for (CodewindConnection conn : CodewindConnectionManager.activeConnections()) {
            if (conn.getBaseURI() == null || !conn.getBaseURI().toString().equals(baseUrl)) continue;
            return conn;
        }
        return null;
    }

    public static synchronized List<CodewindConnection> activeRemoteConnections() {
        return CodewindConnectionManager.activeConnections().stream().filter(conn -> !conn.isLocal()).collect(Collectors.toList());
    }

    public static synchronized CodewindConnection getConnectionById(String id) {
        for (CodewindConnection conn : CodewindConnectionManager.activeConnections()) {
            if (conn.getBaseURI() == null || !conn.getConid().equals(id)) continue;
            return conn;
        }
        return null;
    }

    public static synchronized CodewindConnection getActiveConnectionByName(String name) {
        for (CodewindConnection conn : CodewindConnectionManager.activeConnections()) {
            if (name == null || !name.equals(conn.getName())) continue;
            return conn;
        }
        return null;
    }

    public static synchronized int activeConnectionsCount() {
        return CodewindConnectionManager.instance().connections.size();
    }

    public static synchronized boolean remove(String baseUrl) {
        boolean removeResult = false;
        CodewindConnection connection = CodewindConnectionManager.getActiveConnection(baseUrl.toString());
        if (connection != null) {
            connection.disconnect();
            removeResult = CodewindConnectionManager.instance().connections.remove(connection);
            CoreUtil.removeConnection(connection);
            if (!connection.isLocal() && connection.getConid() != null) {
                try {
                    ConnectionUtil.removeConnection(connection.getConid(), (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception e) {
                    Logger.logError("An error occurred trying to de-register the connection: " + connection.getName());
                }
            }
        }
        if (!removeResult) {
            Logger.logError("Tried to remove connection " + baseUrl + ", but it didn't exist");
        }
        CoreUtil.updateAll();
        return removeResult;
    }

    public static synchronized void clear() {
        if (instance == null) {
            return;
        }
        Logger.log("Clearing " + CodewindConnectionManager.instance().connections.size() + " connections");
        Iterator<CodewindConnection> it = CodewindConnectionManager.instance().connections.iterator();
        while (it.hasNext()) {
            CodewindConnection connection = it.next();
            connection.disconnect();
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IStatus refreshConnections(IProgressMonitor monitor) {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        CodewindManager.getManager().refreshInstallStatus((IProgressMonitor)mon.split(20));
        try {
            List<ConnectionInfo> infos = ConnectionUtil.listConnections((IProgressMonitor)mon.split(20));
            MultiStatus multiStatus = new MultiStatus("org.eclipse.codewind.core", 0, null, null);
            if (infos.size() > 1) {
                mon.setWorkRemaining(100);
            }
            for (ConnectionInfo info2 : infos) {
                try {
                    if (info2.isLocal() || CodewindConnectionManager.getConnectionById(info2.getId()) != null) continue;
                    CodewindConnectionManager.instance().createConnection(info2, (IProgressMonitor)mon.split(50));
                    if (mon.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    mon.setWorkRemaining(100);
                }
                catch (Exception e) {
                    Logger.logError("An error occurred trying to create the " + info2.getLabel() + " connection at: " + info2.getURL());
                    Status status = new Status(4, "org.eclipse.codewind.core", NLS.bind((String)Messages.ConnectionManager_CreateConnError, (Object[])new String[]{info2.getLabel(), info2.getURL()}), (Throwable)e);
                    multiStatus.add((IStatus)status);
                }
                finally {
                    CoreUtil.updateAll();
                }
            }
            Iterator<Object> iterator = CodewindConnectionManager.activeRemoteConnections().iterator();
            while (iterator.hasNext()) {
                CodewindConnection conn = (CodewindConnection)iterator.next();
                mon.setWorkRemaining(10);
                if (infos.stream().filter(info -> conn.getConid().equals(info.getId())).findFirst().isPresent()) continue;
                CodewindConnectionManager.instance().connections.remove(conn);
                CoreUtil.updateAll();
                if (mon.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                mon.worked(5);
            }
            return multiStatus;
        }
        catch (Exception e) {
            Logger.logError("An error occurred trying to refresh the connections", e);
            return new Status(4, "org.eclipse.codewind.core", Messages.ConnectionManager_RefreshGeneralError, (Throwable)e);
        }
    }

    private void restoreConnections() {
        Job job = new Job(Messages.ConnectionManager_RestoreJobLabel){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected IStatus run(IProgressMonitor monitor) {
                SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                CodewindConnectionManager.this.localConnection = CodewindObjectFactory.createLocalConnection(null);
                CodewindConnectionManager.this.connections.add(CodewindConnectionManager.this.localConnection);
                try {
                    CodewindManager.getManager().refreshInstallStatus((IProgressMonitor)mon.split(20));
                }
                catch (Exception e) {
                    Logger.logError("An error occurred trying to connect to the local Codewind instance", e);
                }
                try {
                    List<ConnectionInfo> infos = ConnectionUtil.listConnections((IProgressMonitor)mon.split(20));
                    MultiStatus multiStatus = new MultiStatus("org.eclipse.codewind.core", 0, null, null);
                    if (infos.size() > 1) {
                        mon.setWorkRemaining(100 * (infos.size() - 1));
                    }
                    Iterator<ConnectionInfo> iterator = infos.iterator();
                    while (iterator.hasNext()) {
                        ConnectionInfo info = iterator.next();
                        try {
                            if (info.isLocal()) continue;
                            CodewindConnectionManager.this.createConnection(info, (IProgressMonitor)mon.split(100));
                            if (!mon.isCanceled()) continue;
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        catch (Exception e) {
                            Status status = new Status(4, "org.eclipse.codewind.core", NLS.bind((String)Messages.ConnectionManager_RestoreConnError, (Object[])new String[]{info.getLabel(), info.getURL()}), (Throwable)e);
                            multiStatus.add((IStatus)status);
                        }
                        finally {
                            CoreUtil.updateAll();
                        }
                    }
                    return multiStatus;
                }
                catch (Exception e) {
                    Logger.logError("An error occurred trying to restore the connections", e);
                    return new Status(4, "org.eclipse.codewind.core", Messages.ConnectionManager_RestoreGeneralError, (Throwable)e);
                }
            }

            public boolean belongsTo(Object family) {
                return CodewindConnectionManager.RESTORE_CONNECTIONS_FAMILY.equals(family);
            }
        };
        job.schedule();
    }

    private void createConnection(ConnectionInfo info, IProgressMonitor monitor) throws Exception {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        URI uri = new URI(info.getURL());
        AuthToken auth = null;
        try {
            auth = AuthUtil.getAuthToken(info.getUsername(), info.getId(), (IProgressMonitor)mon.split(20));
        }
        catch (Exception e) {
            Logger.logError("An error occurred trying to get the authorization token for: " + info.getId(), e);
        }
        if (mon.isCanceled()) {
            return;
        }
        CodewindConnection conn = CodewindObjectFactory.createRemoteConnection(info.getLabel(), uri, info.getId(), info.getUsername(), auth);
        this.connections.add(conn);
        if (auth != null) {
            conn.connect((IProgressMonitor)mon.split(80));
        }
    }
}

