/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import org.eclipse.codewind.core.internal.CodewindEclipseApplication;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.console.ProjectLogInfo;
import org.eclipse.codewind.core.internal.console.SocketConsole;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;

public class HideAllLogsAction
extends Action {
    protected CodewindEclipseApplication app;

    public HideAllLogsAction() {
        super(Messages.HideAllLogFilesAction);
    }

    public void setApp(CodewindEclipseApplication app) {
        this.app = app;
        boolean enabled = false;
        if (app.getLogInfos() != null && !app.getLogInfos().isEmpty()) {
            for (ProjectLogInfo logInfo : app.getLogInfos()) {
                if (app.getConsole(logInfo) == null) continue;
                enabled = true;
                break;
            }
        }
        this.setEnabled(enabled);
    }

    public void run() {
        if (this.app == null) {
            Logger.logError((String)"HideAllLogsAction ran but no application was selected");
            return;
        }
        if (this.app.getLogInfos() == null || this.app.getLogInfos().isEmpty()) {
            Logger.logError((String)("HideAllLogsAction ran but there are no logs for the selected application: " + this.app.name));
            return;
        }
        Job job = new Job(NLS.bind((String)Messages.HideAllLogFilesJobLabel, (Object)this.app.name)){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    for (ProjectLogInfo logInfo : HideAllLogsAction.this.app.getLogInfos()) {
                        SocketConsole console = HideAllLogsAction.this.app.getConsole(logInfo);
                        if (console == null) continue;
                        IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
                        consoleManager.removeConsoles(new IConsole[]{console});
                        HideAllLogsAction.this.app.removeConsole(console);
                    }
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    Logger.logError((String)("An error occurred closing the log files for: " + HideAllLogsAction.this.app.name + ", with id: " + HideAllLogsAction.this.app.projectID), (Throwable)e);
                    return new Status(4, "org.eclipse.codewind.ui", NLS.bind((String)Messages.HideAllLogFilesError, (Object)HideAllLogsAction.this.app.name), (Throwable)e);
                }
            }
        };
        job.schedule();
    }
}

