/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import org.eclipse.codewind.core.internal.CodewindManager;
import org.eclipse.codewind.core.internal.cli.InstallStatus;
import org.eclipse.codewind.core.internal.cli.InstallUtil;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.LocalConnection;
import org.eclipse.codewind.ui.internal.IDEUtil;
import org.eclipse.codewind.ui.internal.actions.CodewindInstall;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.views.ViewHelper;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.SelectionProviderAction;

public class LocalDoubleClickAction
extends SelectionProviderAction {
    LocalConnection connection = null;

    public LocalDoubleClickAction(ISelectionProvider selectionProvider) {
        super(selectionProvider, "");
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        Object obj;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof LocalConnection) {
            this.connection = (LocalConnection)obj;
            return;
        }
        this.connection = null;
    }

    public void run() {
        LocalDoubleClickAction.performInstall(this.connection, true);
    }

    public static void performInstall(LocalConnection connection, boolean runFromView) {
        if (connection != null) {
            CodewindManager manager;
            InstallStatus status;
            if (!runFromView) {
                ViewHelper.openCodewindExplorerView();
            }
            if ((status = (manager = CodewindManager.getManager()).getInstallStatus()).isStarted()) {
                if (!runFromView) {
                    IDEUtil.openInfoDialog(Messages.CodewindInstalledDialogTitle, Messages.CodewindInstalledDialogMsg);
                } else {
                    ViewHelper.expandConnection((CodewindConnection)connection);
                }
            } else if (status.isInstalled()) {
                CodewindInstall.startCodewind(status.getVersion(), null);
            } else if (status.hasInstalledVersions()) {
                boolean result = IDEUtil.openConfirmDialog(Messages.UpdateCodewindDialogTitle, Messages.UpdateCodewindDialogMsg);
                if (result) {
                    CodewindInstall.updateCodewind(InstallUtil.getVersion(), true, null);
                }
            } else if (!status.isUnknown()) {
                CodewindInstall.installCodewind(InstallUtil.getVersion(), null);
            }
        }
    }
}

