/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.launch;

import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.launch.CodewindDebugConnector;
import org.eclipse.codewind.core.internal.messages.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;

public class CodewindLaunchConfigDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    public static final String LAUNCH_CONFIG_ID = "org.eclipse.codewind.core.internal.launchConfigurationType";
    public static final String PROJECT_NAME_ATTR = "org.eclipse.codewind.core.internal.projectNameAttr";
    public static final String HOST_ATTR = "org.eclipse.codewind.core.internal.hostAttr";
    public static final String DEBUG_PORT_ATTR = "org.eclipse.codewind.core.internal.debugPort";
    public static final String PROJECT_ID_ATTR = "org.eclipse.codewind.core.internal.projectIdAttr";
    public static final String CONNECTION_ID_ATTR = "org.eclipse.codewind.core.internal.connectionIdAttr";

    public void launch(ILaunchConfiguration config, String launchMode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            this.launchInner(config, launchMode, launch, monitor);
        }
        catch (Exception e) {
            String msg = "An error occurred trying to connect the debugger for launch configuration: " + config.getName();
            Logger.logError(msg, e);
            monitor.setCanceled(true);
            this.getLaunchManager().removeLaunch(launch);
            if (e instanceof CoreException) {
                throw (CoreException)((Object)e);
            }
            this.abort(msg, e, 4);
        }
    }

    private void launchInner(ILaunchConfiguration config, String launchMode, ILaunch launch, IProgressMonitor monitor) throws Exception {
        String projectName = config.getAttribute(PROJECT_NAME_ATTR, (String)null);
        String host = config.getAttribute(HOST_ATTR, (String)null);
        int debugPort = config.getAttribute(DEBUG_PORT_ATTR, -1);
        if (projectName == null || host == null || debugPort <= 0) {
            String msg = "The launch configuration did not contain the required attributes: " + config.getName();
            Logger.logError(msg);
            this.abort(msg, null, 4);
        }
        this.setDefaultSourceLocator(launch, config);
        Logger.log("Connecting the debugger for project: " + projectName);
        IDebugTarget debugTarget = CodewindDebugConnector.connectDebugger(launch, monitor);
        if (debugTarget != null) {
            Logger.log("Debugger connect success. Application should go into Debugging state soon.");
            launch.addDebugTarget(debugTarget);
        } else if (!monitor.isCanceled()) {
            Logger.logError("Debugger connect timeout for project: " + projectName);
            CoreUtil.openDialog(true, Messages.DebuggerConnectFailureDialogTitle, Messages.DebuggerConnectFailureDialogMsg);
            this.getLaunchManager().removeLaunch(launch);
        }
        monitor.done();
    }

    public static void setConfigAttributes(ILaunchConfigurationWorkingCopy config, CodewindApplication app) {
        config.setAttribute(PROJECT_NAME_ATTR, app.name);
        config.setAttribute(HOST_ATTR, app.getDebugConnectHost());
        config.setAttribute(DEBUG_PORT_ATTR, app.getDebugConnectPort());
        config.setAttribute(PROJECT_ID_ATTR, app.projectID);
        config.setAttribute(CONNECTION_ID_ATTR, app.connection.getConid());
    }
}

