/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal;

import java.net.MalformedURLException;
import org.eclipse.codewind.core.CodewindCorePlugin;
import org.eclipse.codewind.core.internal.CodewindEclipseApplication;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.KubeUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.constants.AppStatus;
import org.eclipse.codewind.core.internal.constants.ProjectLanguage;
import org.eclipse.codewind.core.internal.constants.ProjectType;
import org.eclipse.codewind.core.internal.constants.StartMode;
import org.eclipse.codewind.core.internal.messages.Messages;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class RemoteEclipseApplication
extends CodewindEclipseApplication {
    private static final String NOTIFY_PORT_FORWARD_TERMINATED_PREFSKEY = "portForwardTerminated";
    private KubeUtil.PortForwardInfo debugPFInfo = null;

    RemoteEclipseApplication(CodewindConnection connection, String id, String name, ProjectType projectType, ProjectLanguage language, IPath localPath) throws MalformedURLException {
        super(connection, id, name, projectType, language, localPath);
    }

    @Override
    public boolean readyForDebugSession() {
        return StartMode.DEBUG_MODES.contains((Object)this.getStartMode()) && this.getContainerDebugPort() != -1;
    }

    @Override
    public void connectDebugger() {
        try {
            this.debugPFInfo = KubeUtil.startPortForward(this, this.getContainerDebugPort());
        }
        catch (Exception e) {
            Logger.logError("An error occurred trying to port forward the debug port for application: " + this.name, e);
            CoreUtil.openDialog(CoreUtil.DialogType.ERROR, Messages.RemoteDebugErrorTitle, NLS.bind((String)Messages.RemoteDebugPortForwardErrorWithMsg, (Object)this.name, (Object)e.getMessage()));
            return;
        }
        if (this.debugPFInfo == null || this.debugPFInfo.localPort == -1) {
            Logger.logError("Port forwarding of the debug port returned -1 for the local port for application: " + this.name);
            CoreUtil.openDialog(CoreUtil.DialogType.ERROR, Messages.RemoteDebugErrorTitle, NLS.bind((String)Messages.RemoteDebugPortForwardError, (Object)this.name));
            this.debugPFInfo = null;
            return;
        }
        Logger.log("Port forwarding was successful for the debug port of the " + this.name + " application: " + this.debugPFInfo.localPort + ":" + this.debugPFInfo.remotePort);
        CoreUtil.updateApplication(this);
        super.connectDebugger();
    }

    @Override
    public void clearDebugger() {
        super.clearDebugger();
        this.cleanupPortForwarding();
        CoreUtil.updateApplication(this);
    }

    private void cleanupPortForwarding() {
        if (this.debugPFInfo != null) {
            Logger.log("Ending port forwarding for the " + this.name + " application: " + this.debugPFInfo.localPort + ":" + this.debugPFInfo.remotePort);
            KubeUtil.PortForwardInfo info = this.debugPFInfo;
            this.debugPFInfo = null;
            try {
                KubeUtil.endPortForward(this, info);
            }
            catch (Exception e) {
                Logger.logError("An error occurred trying to terminate the debug port forward for: " + this.name, e);
            }
        }
    }

    @Override
    public synchronized int getDebugConnectPort() {
        return this.debugPFInfo == null ? -1 : this.debugPFInfo.localPort;
    }

    @Override
    public synchronized String getDebugConnectHost() {
        return "localhost";
    }

    @Override
    public void launchTerminated(ILaunch launch) {
        if (this.debugPFInfo != null && launch == this.debugPFInfo.launch) {
            IPreferenceStore prefs = CodewindCorePlugin.getDefault().getPreferenceStore();
            if (!prefs.getBoolean(NOTIFY_PORT_FORWARD_TERMINATED_PREFSKEY)) {
                Display.getDefault().asyncExec(() -> {
                    MessageDialogWithToggle portForwardEndDialog = MessageDialogWithToggle.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.PortForwardTerminateTitle, (String)NLS.bind((String)Messages.PortForwardTerminateMsg, (Object[])new String[]{this.name, this.connection.getName(), Integer.toString(this.debugPFInfo.remotePort)}), (String)Messages.PortForwardTerminateToggleMsg, (boolean)false, null, null);
                    prefs.setValue(NOTIFY_PORT_FORWARD_TERMINATED_PREFSKEY, portForwardEndDialog.getToggleState());
                });
            }
            this.debugPFInfo = null;
            CoreUtil.updateApplication(this);
        } else if (launch == this.getLaunch()) {
            this.cleanupPortForwarding();
            CoreUtil.updateApplication(this);
        }
    }

    @Override
    public synchronized void setAppStatus(String appStatus, String appStatusDetails) {
        if (appStatus != null) {
            AppStatus oldStatus = this.getAppStatus();
            super.setAppStatus(appStatus, appStatusDetails);
            if (this.getAppStatus() == AppStatus.STARTING && oldStatus != AppStatus.STARTING && StartMode.DEBUG_MODES.contains((Object)this.getStartMode()) && this.getContainerDebugPort() != -1) {
                this.reconnectDebugger();
            }
        }
    }
}

