/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.launch.CodewindLaunchConfigDelegate;
import org.eclipse.codewind.core.internal.messages.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.osgi.util.NLS;

public class KubeUtil {
    private static final String KUBECTL_TYPE_ATTR = "org.eclipse.codewind.core.internal.kubectlTypeAttr";
    public static final String KUBECTL_PORT_FORWARD = "portforward";
    private static final String KUBECTL_CMD = "kubectl";
    private static final String KUBECTL_EXE = "kubectl.exe";
    private static final String OC_CMD = "oc";
    private static final String OC_EXE = "oc.exe";
    private static String kubeCommand = null;

    public static String getCommand() {
        if (kubeCommand != null) {
            return kubeCommand;
        }
        boolean isWindows = CoreUtil.isWindows();
        String exec = CoreUtil.getExecutablePath(isWindows ? KUBECTL_EXE : KUBECTL_CMD);
        if (exec == null) {
            exec = CoreUtil.getExecutablePath(isWindows ? OC_EXE : OC_CMD);
        }
        kubeCommand = exec;
        return kubeCommand;
    }

    public static Process startPortForward(CodewindApplication app, int localPort, int port) throws Exception {
        if (!KubeUtil.checkApp(app)) {
            return null;
        }
        List<String> commandList = KubeUtil.getPortForwardCommand(app, localPort, port);
        ProcessBuilder builder = new ProcessBuilder(commandList);
        return builder.start();
    }

    public static ILaunch launchPortForward(CodewindApplication app, int localPort, int port) throws Exception {
        if (!KubeUtil.checkApp(app)) {
            return null;
        }
        List<String> commandList = KubeUtil.getPortForwardCommand(app, localPort, port);
        String title = NLS.bind((String)Messages.PortForwardTitle, (Object)(localPort + ":" + port));
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType("org.eclipse.codewind.core.internal.utilityLaunchConfigurationType");
        ILaunchConfigurationWorkingCopy workingCopy = launchConfigurationType.newInstance((IContainer)null, app.name);
        workingCopy.setAttribute("org.eclipse.codewind.core.internal.connectionIdAttr", app.connection.getConid());
        workingCopy.setAttribute("org.eclipse.codewind.core.internal.projectIdAttr", app.projectID);
        workingCopy.setAttribute("org.eclipse.codewind.core.internal.titleAttr", title);
        workingCopy.setAttribute("org.eclipse.codewind.core.internal.commandAttr", commandList);
        workingCopy.setAttribute(KUBECTL_TYPE_ATTR, KUBECTL_PORT_FORWARD);
        CodewindLaunchConfigDelegate.setConfigAttributes(workingCopy, app);
        ILaunchConfiguration launchConfig = workingCopy.doSave();
        return launchConfig.launch("run", (IProgressMonitor)new NullProgressMonitor());
    }

    private static boolean checkApp(CodewindApplication app) {
        if (app.getPodName() == null || app.getNamespace() == null) {
            Logger.logError("Trying to port forward for the " + app.name + " project but the pod name or the namespace is null");
            return false;
        }
        return true;
    }

    private static List<String> getPortForwardCommand(CodewindApplication app, int localPort, int port) throws Exception {
        String processPath = KubeUtil.getCommand();
        if (processPath == null) {
            Logger.logError("Port forwarding cannot be initiated because neither of the kubectl or oc commands could be found on the path");
            throw new IOException(Messages.ErrorNoKubectlMsg);
        }
        String portMapping = localPort + ":" + port;
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add(processPath);
        commandList.add("port-forward");
        commandList.add("-n");
        commandList.add(app.getNamespace());
        commandList.add(app.getPodName());
        commandList.add(portMapping);
        return commandList;
    }

    public static boolean isLaunchMatch(ILaunch launch, String type) {
        try {
            return type.equals(launch.getLaunchConfiguration().getAttribute(KUBECTL_TYPE_ATTR, (String)null));
        }
        catch (CoreException e) {
            return false;
        }
    }
}

