/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal;

import java.io.IOException;
import java.net.MalformedURLException;
import org.eclipse.codewind.core.CodewindCorePlugin;
import org.eclipse.codewind.core.internal.CodewindEclipseApplication;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.KubeUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.PlatformUtil;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.constants.AppStatus;
import org.eclipse.codewind.core.internal.constants.ProjectLanguage;
import org.eclipse.codewind.core.internal.constants.ProjectType;
import org.eclipse.codewind.core.internal.constants.StartMode;
import org.eclipse.codewind.core.internal.messages.Messages;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class RemoteEclipseApplication
extends CodewindEclipseApplication {
    private static final String NOTIFY_PORT_FORWARD_TERMINATED_PREFSKEY = "portForwardTerminated";
    private int debugConnectPort = -1;

    RemoteEclipseApplication(CodewindConnection connection, String id, String name, ProjectType projectType, ProjectLanguage language, IPath localPath) throws MalformedURLException {
        super(connection, id, name, projectType, language, localPath);
    }

    @Override
    public boolean readyForDebugSession() {
        return StartMode.DEBUG_MODES.contains((Object)this.getStartMode()) && this.getContainerDebugPort() != -1;
    }

    @Override
    public String getLaunchConfigId() {
        return "org.eclipse.codewind.core.internal.remoteLaunchConfigurationType";
    }

    @Override
    public void preDebugSetup() throws Exception {
        this.debugConnectPort = PlatformUtil.findFreePort();
        if (this.debugConnectPort <= 0) {
            String msg = "Could not find a free port for port forwarding the debug port for project: " + this.name;
            Logger.logError(msg);
            throw new IOException(msg);
        }
        KubeUtil.launchPortForward(this, this.debugConnectPort, this.getContainerDebugPort());
    }

    @Override
    public void clearDebugger() {
        super.clearDebugger();
        this.debugConnectPort = -1;
        CoreUtil.updateApplication(this);
    }

    public synchronized void setDebugConnectPort(int port) {
        this.debugConnectPort = port;
    }

    @Override
    public synchronized int getDebugConnectPort() {
        return this.debugConnectPort;
    }

    @Override
    public synchronized String getDebugConnectHost() {
        return "localhost";
    }

    @Override
    public void launchTerminated(ILaunch launch) {
        if (KubeUtil.isLaunchMatch(launch, "portforward")) {
            IPreferenceStore prefs = CodewindCorePlugin.getDefault().getPreferenceStore();
            if (!prefs.getBoolean(NOTIFY_PORT_FORWARD_TERMINATED_PREFSKEY)) {
                Display.getDefault().asyncExec(() -> {
                    MessageDialogWithToggle portForwardEndDialog = MessageDialogWithToggle.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.PortForwardTerminateTitle, (String)NLS.bind((String)Messages.PortForwardTerminateMsg, (Object[])new String[]{this.name, this.connection.getName(), Integer.toString(this.getContainerDebugPort())}), (String)Messages.PortForwardTerminateToggleMsg, (boolean)false, null, null);
                    prefs.setValue(NOTIFY_PORT_FORWARD_TERMINATED_PREFSKEY, portForwardEndDialog.getToggleState());
                });
            }
            this.debugConnectPort = -1;
            CoreUtil.updateApplication(this);
        } else if (launch == this.getLaunch()) {
            this.debugConnectPort = -1;
            CoreUtil.updateApplication(this);
        }
    }

    @Override
    public synchronized void setAppStatus(String appStatus, String appStatusDetails) {
        if (appStatus != null) {
            AppStatus oldStatus = this.getAppStatus();
            super.setAppStatus(appStatus, appStatusDetails);
            if (this.getAppStatus() == AppStatus.STARTING && oldStatus != AppStatus.STARTING && StartMode.DEBUG_MODES.contains((Object)this.getStartMode()) && this.getContainerDebugPort() != -1) {
                this.reconnectDebugger();
            }
        }
    }
}

