/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.CodewindConnectionManager;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionProviderAction;

public class RemoveConnectionAction
extends SelectionProviderAction {
    protected CodewindConnection connection;

    public RemoveConnectionAction(ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.RemoveConnectionActionLabel);
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        Object obj;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof CodewindConnection) {
            this.connection = (CodewindConnection)obj;
            this.setEnabled(this.connection != null);
            return;
        }
        this.setEnabled(false);
    }

    public void run() {
        if (this.connection == null) {
            Logger.logError((String)"RemoveConnectionAction ran but no connection was selected");
            return;
        }
        if (!MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)Messages.RemoveConnectionActionConfirmTitle, (String)NLS.bind((String)Messages.RemoveConnectionActionConfirmMsg, (Object[])new String[]{this.connection.getName(), this.connection.getBaseURI().toString()}))) {
            return;
        }
        try {
            CodewindConnectionManager.remove((String)this.connection.getBaseURI().toString());
        }
        catch (Exception e) {
            Logger.logError((String)("Error removing connection: " + this.connection.getBaseURI().toString()), (Throwable)e);
        }
    }
}

