/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.launch;

import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.codewind.core.internal.KubeUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.PlatformUtil;
import org.eclipse.codewind.core.internal.RemoteEclipseApplication;
import org.eclipse.codewind.core.internal.launch.CodewindLaunchConfigDelegate;
import org.eclipse.codewind.core.internal.messages.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.RuntimeProcess;
import org.eclipse.osgi.util.NLS;

public class RemoteLaunchConfigDelegate
extends CodewindLaunchConfigDelegate {
    public static final String LAUNCH_CONFIG_ID = "org.eclipse.codewind.core.internal.remoteLaunchConfigurationType";

    @Override
    public void launch(ILaunchConfiguration config, String launchMode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            this.launchInner(config, launchMode, launch, monitor);
        }
        catch (Exception e) {
            String msg = "An error occurred trying to connect the debugger for launch configuration: " + config.getName();
            Logger.logError(msg, e);
            monitor.setCanceled(true);
            this.getLaunchManager().removeLaunch(launch);
            if (e instanceof CoreException) {
                throw (CoreException)((Object)e);
            }
            this.abort(msg, e, 4);
        }
    }

    private void launchInner(ILaunchConfiguration config, String launchMode, final ILaunch launch, IProgressMonitor monitor) throws Exception {
        int localPort;
        RemoteEclipseApplication app = (RemoteEclipseApplication)this.getApp(config);
        if (app.getContainerDebugPort() <= 0) {
            String msg = "The container debug port is not set up for application: " + app.name;
            Logger.logError(msg);
            this.abort(msg, null, 4);
        }
        if ((localPort = PlatformUtil.findFreePort()) <= 0) {
            String msg = "Could not find a free port for port forwarding the debug port for launch config: " + config.getName();
            Logger.logError(msg);
            this.abort(msg, null, 4);
        }
        KubeUtil.PortForwardInfo pfInfo = KubeUtil.startPortForward(app, localPort, app.getContainerDebugPort());
        app.setDebugPFInfo(pfInfo);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(IProcess.ATTR_PROCESS_TYPE, "codewind.utility");
        String title = NLS.bind((String)Messages.PortForwardTitle, (Object)(localPort + ":" + app.getContainerDebugPort()));
        launch.addProcess((IProcess)new RuntimeProcess(launch, pfInfo.process, title, attributes));
        DebugPlugin.getDefault().addDebugEventListener(new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                for (DebugEvent event : events) {
                    if (event.getKind() != 8 || !(event.getSource() instanceof IDebugTarget) || ((IDebugTarget)event.getSource()).getLaunch() != launch) continue;
                    DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                    Arrays.stream(launch.getProcesses()).filter(process -> !process.isTerminated()).forEach(process -> {
                        try {
                            process.terminate();
                        }
                        catch (DebugException e) {
                            Logger.logError("An error occurred trying to terminate the process: " + process.getLabel(), e);
                        }
                    });
                    break;
                }
            }
        });
        super.launch(config, launchMode, launch, monitor);
    }
}

