/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal;

import java.net.URI;
import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.cli.InstallStatus;
import org.eclipse.codewind.core.internal.cli.InstallUtil;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.CodewindConnectionManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;

public class CodewindManager {
    private static CodewindManager codewindManager;
    InstallStatus installStatus = InstallStatus.UNKNOWN;
    InstallerStatus installerStatus = null;
    String installerErrorMsg = null;

    private CodewindManager() {
    }

    public static synchronized CodewindManager getManager() {
        if (codewindManager == null) {
            codewindManager = new CodewindManager();
        }
        return codewindManager;
    }

    public InstallStatus getInstallStatus() {
        return this.installStatus;
    }

    public String getInstallerErrorMsg() {
        return this.installerErrorMsg;
    }

    public synchronized void refreshInstallStatus(IProgressMonitor monitor) {
        String urlStr = null;
        this.installerErrorMsg = null;
        try {
            SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            this.installStatus = InstallUtil.getInstallStatus((IProgressMonitor)mon.split(60));
            CodewindConnection localConnection = CodewindConnectionManager.getLocalConnection();
            if (localConnection != null) {
                if (this.installStatus.isStarted()) {
                    urlStr = this.installStatus.getURL();
                    if (!localConnection.isConnected()) {
                        URI uri = new URI(urlStr);
                        localConnection.setBaseURI(uri);
                        localConnection.connect((IProgressMonitor)mon.split(40));
                    }
                } else {
                    localConnection.disconnect();
                    localConnection.setBaseURI(null);
                }
            }
            return;
        }
        catch (Exception e) {
            Logger.logError("An error occurred trying to get the Codewind install status.", e);
            this.installerErrorMsg = e.getLocalizedMessage();
            this.installStatus = InstallStatus.UNKNOWN;
            return;
        }
    }

    public InstallerStatus getInstallerStatus() {
        return this.installerStatus;
    }

    public void setInstallerStatus(InstallerStatus status) {
        this.installerStatus = status;
        CoreUtil.updateConnection(CodewindConnectionManager.getLocalConnection());
    }

    public boolean isSupportedVersion(String version) {
        return CodewindConnection.isSupportedVersion(version);
    }

    public IStatus refresh(IProgressMonitor monitor) {
        IStatus status = CodewindConnectionManager.refreshConnections(monitor);
        for (CodewindConnection conn : CodewindConnectionManager.activeConnections()) {
            if (!conn.isConnected()) continue;
            conn.refreshApps(null);
        }
        return status;
    }

    public boolean hasActiveApplications() {
        for (CodewindConnection conn : CodewindConnectionManager.activeConnections()) {
            for (CodewindApplication app : conn.getApps()) {
                if (!app.isAvailable()) continue;
                return true;
            }
        }
        return false;
    }

    public static enum InstallerStatus {
        INSTALLING,
        UNINSTALLING,
        STARTING,
        STOPPING;

    }
}

