/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.launch;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Map;
import org.eclipse.codewind.core.CodewindCorePlugin;
import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.launch.LaunchUtilities;
import org.eclipse.codewind.core.internal.messages.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.osgi.util.NLS;

public class CodewindDebugConnector {
    public static IDebugTarget connectDebugger(ILaunch launch, CodewindApplication app, IProgressMonitor monitor) throws IllegalConnectorArgumentsException, CoreException, IOException {
        Logger.log("Beginning to try to connect debugger");
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        Logger.log("Debugging on port " + app.getDebugConnectPort());
        int timeout = CodewindCorePlugin.getDefault().getPreferenceStore().getInt("serverDebugTimeout");
        Logger.log("Debugger connect timeout is " + timeout + "s");
        AttachingConnector connector = LaunchUtilities.getAttachingConnector();
        if (connector == null) {
            String msg = "Could not create debug connector for launch configuration: " + config.getName();
            Logger.logError(msg);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.codewind.core", msg));
        }
        Map<String, Connector.Argument> connectorArgs = connector.defaultArguments();
        connectorArgs = LaunchUtilities.configureConnector(connectorArgs, app.getDebugConnectHost(), app.getDebugConnectPort());
        boolean retry = false;
        try {
            VirtualMachine vm = null;
            Exception ex = null;
            int itr = timeout * 4;
            if (itr <= 0) {
                itr = 2;
            }
            while (itr-- > 0) {
                block14: {
                    if (monitor.isCanceled()) {
                        Logger.log("User cancelled debugger connecting");
                        return null;
                    }
                    try {
                        vm = connector.attach(connectorArgs);
                        itr = 0;
                        ex = null;
                    }
                    catch (Exception e) {
                        ex = e;
                        if (itr % 8 != 0) break block14;
                        Logger.log("Waiting for debugger attach.");
                    }
                }
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException e) {}
            }
            if (ex instanceof IllegalConnectorArgumentsException) {
                throw (IllegalConnectorArgumentsException)ex;
            }
            if (ex instanceof InterruptedIOException) {
                throw (InterruptedIOException)ex;
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            IDebugTarget debugTarget = null;
            if (vm != null) {
                LaunchUtilities.setDebugTimeout(vm);
                String debugName = CodewindDebugConnector.getDebugLaunchName(app.name, app.getDebugConnectHost(), String.valueOf(app.getDebugConnectPort()));
                debugTarget = LaunchUtilities.createLocalJDTDebugTarget(launch, app.getDebugConnectPort(), null, vm, debugName, false);
                monitor.worked(1);
                monitor.done();
            }
            return debugTarget;
        }
        catch (InterruptedIOException e) {
            Status status = new Status(4, "org.eclipse.codewind.core", 117, "", (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private static String getDebugLaunchName(String projectName, String host, String debugPort) {
        return NLS.bind((String)Messages.DebugLaunchConfigName, (Object[])new Object[]{projectName, host, debugPort});
    }
}

