/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import java.net.URL;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.connection.ConnectionEnv;
import org.eclipse.codewind.core.internal.connection.RemoteConnection;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class OpenTektonDashboardAction
extends SelectionProviderAction {
    protected RemoteConnection conn;

    public OpenTektonDashboardAction(ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.ActionOpenTektonDashboard);
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        Object obj;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof RemoteConnection) {
            this.conn = (RemoteConnection)obj;
            this.setEnabled(this.conn.isConnected());
            return;
        }
        this.setEnabled(false);
    }

    public void run() {
        if (this.conn == null) {
            Logger.logError((String)"OpenTektonDashboardAction ran but no remote connection was selected");
            return;
        }
        ConnectionEnv.TektonDashboard tekton = this.conn.getTektonDashboard();
        if (tekton == null) {
            Logger.logError((String)"OpenTektonDashboardAction ran but there is no tekton dashboard in the environment");
            return;
        }
        if (!tekton.hasTektonDashboard()) {
            Logger.logError((String)("Tekton dashboard is not available: " + tekton.getTektonMessage()));
            String errorMsg = tekton.isNotInstalled() ? Messages.ActionOpenTektonDashboardNotInstalled : Messages.ActionOpenTektonDashboardOtherError;
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.ActionOpenTektonDashboardErrorDialogTitle, (String)errorMsg);
            return;
        }
        URL url = tekton.getTektonUrl();
        if (url == null) {
            Logger.logError((String)"OpenTektonDashboardAction ran but could not get the url");
            return;
        }
        try {
            IWebBrowser browser = null;
            IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
            if (CoreUtil.isWindows()) {
                browser = browserSupport.getExternalBrowser();
            }
            if (browser == null) {
                browser = browserSupport.createBrowser(6, this.conn.getConid() + "_tektonDashboard", this.conn.getName(), NLS.bind((String)Messages.BrowserTooltipTektonDashboard, (Object)this.conn.getName()));
            }
            browser.openURL(url);
        }
        catch (PartInitException e) {
            Logger.logError((String)"Error opening the Tekton dashboard in browser", (Throwable)e);
        }
    }

    public boolean showAction() {
        return this.conn != null && this.conn.isConnected() && this.conn.getTektonDashboard() != null;
    }
}

