/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import java.util.List;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.cli.RegistryUtil;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.ImagePushRegistryInfo;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.prefs.RegistryManagementDialog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionProviderAction;

public class ManageRegistriesAction
extends SelectionProviderAction {
    protected CodewindConnection connection;

    public ManageRegistriesAction(ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.RegMgmtActionLabel);
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        Object obj;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof CodewindConnection) {
            this.connection = (CodewindConnection)obj;
            this.setEnabled(this.connection.isConnected());
            return;
        }
        this.setEnabled(false);
    }

    public void run() {
        if (this.connection == null) {
            Logger.logError((String)"ManageRegistriesAction ran but no Codewind connection was selected");
            return;
        }
        try {
            List regList = RegistryUtil.listRegistrySecrets((String)this.connection.getConid(), (IProgressMonitor)new NullProgressMonitor());
            ImagePushRegistryInfo pushReg = this.connection.requestGetPushRegistry();
            final RegistryManagementDialog regDialog = new RegistryManagementDialog(Display.getDefault().getActiveShell(), this.connection, regList, pushReg);
            if (regDialog.open() == 0 && regDialog.hasChanges()) {
                Job job = new Job(Messages.RegUpdateTask){

                    protected IStatus run(IProgressMonitor monitor) {
                        return regDialog.updateRegistries(monitor);
                    }
                };
                job.schedule();
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.RegListErrorTitle, (String)NLS.bind((String)Messages.RegListErrorMsg, (Object)e));
        }
    }
}

