/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.launch;

import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.CodewindConnectionManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchesListener2;

public class CodewindLaunchListener
implements ILaunchesListener2 {
    public void launchesAdded(ILaunch[] launches) {
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    public void launchesRemoved(ILaunch[] launches) {
    }

    public void launchesTerminated(ILaunch[] launches) {
        for (ILaunch launch : launches) {
            ILaunchConfiguration config = launch.getLaunchConfiguration();
            try {
                CodewindApplication app;
                if (!config.hasAttribute("org.eclipse.codewind.core.internal.connectionIdAttr") || !config.hasAttribute("org.eclipse.codewind.core.internal.projectIdAttr")) continue;
                CodewindConnection conn = CodewindConnectionManager.getConnectionById(config.getAttribute("org.eclipse.codewind.core.internal.connectionIdAttr", ""));
                CodewindApplication codewindApplication = app = conn == null ? null : conn.getAppByID(config.getAttribute("org.eclipse.codewind.core.internal.projectIdAttr", ""));
                if (app == null) continue;
                app.launchTerminated(launch);
            }
            catch (CoreException e) {
                Logger.logError("An error occurred trying to look up the application for a launch configuration", e);
            }
        }
    }
}

