/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.prefs;

import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.cli.ProjectLinks;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.prefs.LinkManagementComposite;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class LinkManagementDialog
extends TitleAreaDialog {
    private final CodewindApplication srcApp;
    private final ProjectLinks projectLinks;
    private LinkManagementComposite linkComposite;

    public LinkManagementDialog(Shell parentShell, CodewindApplication srcApp, ProjectLinks projectLinks) {
        super(parentShell);
        this.srcApp = srcApp;
        this.projectLinks = projectLinks;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.LinkMgmtDialogTitle);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createButtonBar(Composite parent) {
        return super.createButtonBar(parent);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitleImage(CodewindUIPlugin.getImage("codewindBanner.png"));
        this.setTitle(Messages.LinkMgmtDialogTitle);
        this.setMessage(NLS.bind((String)Messages.LinkMgmtDialogMessage, (Object)this.srcApp.name));
        Composite content = (Composite)super.createDialogArea(parent);
        content.setLayout((Layout)new GridLayout());
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        this.linkComposite = new LinkManagementComposite(content, this.srcApp, this.projectLinks);
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = 250;
        this.linkComposite.setLayoutData(data);
        return parent;
    }

    public boolean hasChanges() {
        return this.linkComposite.hasChanges();
    }

    public IStatus updateLinks(IProgressMonitor monitor) {
        return this.linkComposite.updateLinks(monitor);
    }

    protected Point getInitialSize() {
        Point point = super.getInitialSize();
        return new Point(700, point.y);
    }
}

