/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.prefs;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.cli.ProjectLinks;
import org.eclipse.codewind.core.internal.cli.ProjectUtil;
import org.eclipse.codewind.core.internal.constants.AppStatus;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.UIConstants;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.dialogs.SearchPattern;

public class LinkManagementComposite
extends Composite {
    private final CodewindApplication srcApp;
    private final ProjectLinks projectLinks;
    private List<LinkEntry> linkEntries;
    private Table linkTable;
    private Button addButton;
    private Button renameButton;
    private Button removeButton;
    private SearchPattern pattern = new SearchPattern(35);

    public LinkManagementComposite(Composite parent, CodewindApplication app, ProjectLinks projectLinks) {
        super(parent, 0);
        this.srcApp = app;
        this.projectLinks = projectLinks;
        this.linkEntries = this.getLinkEntries(projectLinks);
        this.createControl();
    }

    protected void createControl() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        layout.horizontalSpacing = 7;
        layout.verticalSpacing = 5;
        this.setLayout((Layout)layout);
        Text description = new Text((Composite)this, 74);
        description.setText("");
        description.setBackground(this.getBackground());
        description.setForeground(this.getForeground());
        description.setLayoutData((Object)new GridData(4, 3, true, false, 1, 1));
        Link learnMoreLink = new Link((Composite)this, 0);
        learnMoreLink.setText("<a>" + Messages.LinkMgmtLearnMoreLink + "</a>");
        learnMoreLink.setLayoutData((Object)new GridData(3, 3, false, false, 1, 1));
        learnMoreLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                    IWebBrowser browser = browserSupport.getExternalBrowser();
                    URL url = new URL(UIConstants.REGISTRY_INFO_URL);
                    browser.openURL(url);
                }
                catch (Exception e) {
                    Logger.logError((String)("An error occurred trying to open an external browser at: " + UIConstants.TEMPLATES_INFO_URL), (Throwable)e);
                }
            }
        });
        new Label((Composite)this, 0).setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        Composite tableComp = new Composite((Composite)this, 0);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComp.setLayout((Layout)tableColumnLayout);
        tableComp.setLayoutData((Object)new GridData(4, 4, true, true, 1, 3));
        this.linkTable = new Table(tableComp, 68354);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 100;
        this.linkTable.setLayoutData((Object)data);
        TableColumn projectColumn = new TableColumn(this.linkTable, 0);
        projectColumn.setText(Messages.LinkMgmtProjectColumn);
        projectColumn.setResizable(true);
        TableColumn envVarColumn = new TableColumn(this.linkTable, 0);
        envVarColumn.setText(Messages.LinkMgmtEnvVarColumn);
        envVarColumn.setResizable(true);
        this.linkTable.setHeaderVisible(true);
        this.linkTable.setLinesVisible(true);
        this.linkTable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                LinkManagementComposite.this.updateButtons();
            }
        });
        this.addButton = new Button((Composite)this, 8);
        this.addButton.setText(Messages.LinkMgmtAddButton);
        this.addButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.renameButton = new Button((Composite)this, 8);
        this.renameButton.setText(Messages.LinkMgmtRenameButton);
        this.renameButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.removeButton = new Button((Composite)this, 8);
        this.removeButton.setText(Messages.LinkMgmtRemoveButton);
        this.removeButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LinkEntry linkEntry;
                AddDialog dialog = new AddDialog(LinkManagementComposite.this.getShell());
                if (dialog.open() == 0 && (linkEntry = dialog.getNewLinkEntry()) != null) {
                    LinkManagementComposite.this.linkEntries.add(linkEntry);
                    LinkManagementComposite.this.createItems();
                }
            }
        });
        this.renameButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LinkEntry linkEntry = (LinkEntry)LinkManagementComposite.this.linkTable.getSelection()[0].getData();
                RenameDialog dialog = new RenameDialog(LinkManagementComposite.this.getShell(), linkEntry.envVar);
                if (dialog.open() == 0) {
                    String newName = dialog.getEnvVar();
                    linkEntry.envVar = newName;
                    LinkManagementComposite.this.createItems();
                }
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Arrays.stream(LinkManagementComposite.this.linkTable.getSelection()).forEach(item -> LinkManagementComposite.this.linkEntries.remove(item.getData()));
                LinkManagementComposite.this.createItems();
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this, CodewindUIPlugin.MAIN_CONTEXTID);
        description.setText(NLS.bind((String)Messages.LinkMgmtDescription, (Object)this.srcApp.name, (Object)this.srcApp.connection.getName()));
        Arrays.stream(this.linkTable.getColumns()).forEach(TableColumn::pack);
        tableColumnLayout.setColumnData((Widget)projectColumn, (ColumnLayoutData)new ColumnWeightData(10, Math.max(150, projectColumn.getWidth()), true));
        tableColumnLayout.setColumnData((Widget)envVarColumn, (ColumnLayoutData)new ColumnWeightData(10, Math.max(150, envVarColumn.getWidth()), true));
        this.createItems();
        this.updateButtons();
        this.linkTable.setFocus();
    }

    public boolean setFocus() {
        return this.linkTable.setFocus();
    }

    private void createItems() {
        this.linkTable.removeAll();
        for (LinkEntry linkEntry : this.linkEntries) {
            TableItem item = new TableItem(this.linkTable, 0);
            item.setData((Object)linkEntry);
            item.setText(0, ((LinkEntry)linkEntry).targetApp.name);
            item.setText(1, linkEntry.envVar);
        }
    }

    private void updateButtons() {
        this.renameButton.setEnabled(this.linkTable.getSelectionCount() == 1);
        this.removeButton.setEnabled(this.linkTable.getSelectionCount() > 0);
    }

    private List<LinkEntry> getLinkEntries(ProjectLinks links) {
        return links.getLinks().stream().map(link -> new LinkEntry((ProjectLinks.LinkInfo)link)).collect(Collectors.toList());
    }

    public IStatus updateLinks(IProgressMonitor monitor) {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.LinkUpdateTask, (int)100);
        MultiStatus multiStatus = new MultiStatus("org.eclipse.codewind.core", 4, Messages.LinkMgmtUpdateError, null);
        for (ProjectLinks.LinkInfo info : this.projectLinks.getLinks()) {
            Optional<LinkEntry> entry = this.getLinkEntry(info);
            if (!entry.isPresent()) {
                try {
                    ProjectUtil.removeLink((String)this.srcApp.name, (String)this.srcApp.projectID, (String)info.getProjectId(), (String)info.getEnvVar(), (IProgressMonitor)mon.split(25));
                }
                catch (Exception e) {
                    Logger.logError((String)("Failed to remove link for " + this.srcApp.name + " with variable: " + info.getEnvVar()), (Throwable)e);
                    multiStatus.add((IStatus)new Status(4, "org.eclipse.codewind.core", NLS.bind((String)Messages.LinkMgmtRemoveFailed, (Object)this.srcApp.name, (Object)info.getEnvVar()), (Throwable)e));
                }
            } else if (!entry.get().envVar.equals(info.getEnvVar())) {
                try {
                    ProjectUtil.renameLink((String)this.srcApp.name, (String)this.srcApp.projectID, (String)info.getEnvVar(), (String)entry.get().envVar, (IProgressMonitor)mon.split(25));
                }
                catch (Exception e) {
                    Logger.logError((String)("Failed to remove link for " + this.srcApp.name + " with variable: " + info.getEnvVar()), (Throwable)e);
                    multiStatus.add((IStatus)new Status(4, "org.eclipse.codewind.core", NLS.bind((String)Messages.LinkMgmtRemoveFailed, (Object)this.srcApp.name, (Object)info.getEnvVar()), (Throwable)e));
                }
            }
            if (mon.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            mon.setWorkRemaining(100);
        }
        for (LinkEntry entry : this.linkEntries) {
            if (entry.info == null) {
                try {
                    ProjectUtil.createLink((String)this.srcApp.name, (String)this.srcApp.projectID, (String)((LinkEntry)entry).targetApp.name, (String)((LinkEntry)entry).targetApp.projectID, (String)entry.envVar, (IProgressMonitor)mon.split(25));
                }
                catch (Exception e) {
                    Logger.logError((String)("Failed to create a link from " + this.srcApp.name + " to " + ((LinkEntry)entry).targetApp.name + " with variable: " + entry.envVar), (Throwable)e);
                    multiStatus.add((IStatus)new Status(4, "org.eclipse.codewind.core", NLS.bind((String)Messages.LinkMgmtAddFailed, (Object[])new String[]{this.srcApp.name, ((LinkEntry)entry).targetApp.name, entry.envVar}), (Throwable)e));
                }
            }
            if (mon.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            mon.setWorkRemaining(100);
        }
        if (multiStatus.getChildren().length > 0) {
            return multiStatus;
        }
        return Status.OK_STATUS;
    }

    public boolean hasChanges() {
        for (ProjectLinks.LinkInfo info : this.projectLinks.getLinks()) {
            Optional<LinkEntry> entry = this.getLinkEntry(info);
            if (entry.isPresent() && entry.get().envVar.equals(info.getEnvVar())) continue;
            return true;
        }
        for (LinkEntry entry : this.linkEntries) {
            if (entry.info != null) continue;
            return true;
        }
        return false;
    }

    private Optional<LinkEntry> getLinkEntry(ProjectLinks.LinkInfo info) {
        return this.linkEntries.stream().filter(entry -> ((LinkEntry)entry).info == info).findFirst();
    }

    private Optional<LinkEntry> getLinkEntry(String projectName, String envVar) {
        return this.linkEntries.stream().filter(entry -> ((LinkEntry)entry).targetApp.name.equals(projectName) && ((LinkEntry)entry).envVar.equals(envVar)).findFirst();
    }

    private class RenameDialog
    extends TitleAreaDialog {
        private String oldEnvVar;
        private String envVar;
        private Text envVarText;

        public RenameDialog(Shell parentShell, String oldEnvVar) {
            super(parentShell);
            this.oldEnvVar = oldEnvVar;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(Messages.LinkMgmtRenameDialogShell);
        }

        protected boolean isResizable() {
            return true;
        }

        protected Control createButtonBar(Composite parent) {
            return super.createButtonBar(parent);
        }

        protected Control createDialogArea(Composite parent) {
            this.setTitleImage(CodewindUIPlugin.getImage("codewindBanner.png"));
            this.setTitle(Messages.LinkMgmtRenameDialogTitle);
            this.setMessage(Messages.LinkMgmtRenameDialogMessage);
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 11;
            layout.marginWidth = 9;
            layout.horizontalSpacing = 5;
            layout.verticalSpacing = 7;
            layout.numColumns = 2;
            composite.setLayout((Layout)layout);
            GridData data = new GridData(1808);
            data.minimumWidth = 300;
            composite.setLayoutData((Object)data);
            composite.setFont(parent.getFont());
            Label variableLabel = new Label(composite, 0);
            variableLabel.setText(Messages.LinkMgmtAddDialogEnvVarLabel);
            data = new GridData(1, 2, false, false);
            data.horizontalIndent = 15;
            variableLabel.setLayoutData((Object)data);
            this.envVarText = new Text(composite, 2048);
            this.envVarText.setLayoutData((Object)new GridData(4, 4, true, false));
            this.envVarText.setText(this.oldEnvVar);
            this.envVarText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    RenameDialog.this.enableOKButton(RenameDialog.this.validate());
                }
            });
            this.envVarText.selectAll();
            this.envVarText.setFocus();
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            this.enableOKButton(false);
        }

        protected void enableOKButton(boolean value) {
            this.getButton(0).setEnabled(value);
        }

        protected void okPressed() {
            this.envVar = this.envVarText.getText();
            super.okPressed();
        }

        private boolean validate() {
            if (this.envVarText.getText() == null || this.envVarText.getText().trim().isEmpty()) {
                this.setErrorMessage(Messages.LinkMgmtAddDialogNoEnvVar);
            }
            this.setErrorMessage(null);
            return true;
        }

        public String getEnvVar() {
            return this.envVar;
        }

        protected Point getInitialSize() {
            Point point = super.getInitialSize();
            return new Point(650, point.y);
        }
    }

    private class AddDialog
    extends TitleAreaDialog {
        private String projectName;
        private String envVar;
        private org.eclipse.swt.widgets.List projectList;
        private Text envVarText;

        public AddDialog(Shell parentShell) {
            super(parentShell);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(Messages.LinkMgmtAddDialogShell);
        }

        protected boolean isResizable() {
            return true;
        }

        protected Control createButtonBar(Composite parent) {
            return super.createButtonBar(parent);
        }

        protected Control createDialogArea(Composite parent) {
            this.setTitleImage(CodewindUIPlugin.getImage("codewindBanner.png"));
            this.setTitle(Messages.LinkMgmtAddDialogTitle);
            this.setMessage(Messages.LinkMgmtAddDialogMessage);
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 11;
            layout.marginWidth = 9;
            layout.horizontalSpacing = 5;
            layout.verticalSpacing = 15;
            layout.numColumns = 2;
            composite.setLayout((Layout)layout);
            GridData data = new GridData(1808);
            data.minimumWidth = 300;
            composite.setLayoutData((Object)data);
            composite.setFont(parent.getFont());
            Group projectGroup = new Group(composite, 0);
            projectGroup.setText("Select a target project");
            layout = new GridLayout();
            layout.marginHeight = 11;
            layout.marginWidth = 9;
            layout.horizontalSpacing = 5;
            layout.verticalSpacing = 7;
            projectGroup.setLayout((Layout)layout);
            projectGroup.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
            final Text filterText = new Text((Composite)projectGroup, 2176);
            filterText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            filterText.setMessage(Messages.LinkMgmtAddDialogProjectFilterText);
            filterText.setText(this.getFilterMessage());
            this.projectList = new org.eclipse.swt.widgets.List((Composite)projectGroup, 2820);
            data = new GridData(4, 4, true, true);
            data.heightHint = 200;
            this.projectList.setLayoutData((Object)data);
            Label label = new Label(composite, 0);
            label.setText(Messages.LinkMgmtAddDialogEnvVarLabel);
            label.setLayoutData((Object)new GridData(1, 2, false, false));
            this.envVarText = new Text(composite, 0);
            this.envVarText.setLayoutData((Object)new GridData(4, 4, true, false));
            filterText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    String filter = AddDialog.this.getFilterMessage().equals(filterText.getText().trim()) ? "" : filterText.getText();
                    AddDialog.this.createItems(AddDialog.this.projectList, filter);
                    if (AddDialog.this.projectList.getItemCount() > 0) {
                        AddDialog.this.projectList.setSelection(0);
                    }
                    AddDialog.this.enableOKButton(AddDialog.this.validate());
                }
            });
            filterText.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    Display display = filterText.getDisplay();
                    display.asyncExec(() -> {
                        if (!filterText.isDisposed() && AddDialog.this.getFilterMessage().equals(filterText.getText().trim())) {
                            filterText.selectAll();
                        }
                    });
                }

                public void focusLost(FocusEvent e) {
                    if (AddDialog.this.getFilterMessage().equals(filterText.getText().trim())) {
                        filterText.setText("");
                    }
                }
            });
            filterText.addListener(1, new Listener(){

                public void handleEvent(Event event) {
                    if (event.keyCode == 0x1000002) {
                        if (AddDialog.this.projectList.getItemCount() > 0) {
                            AddDialog.this.projectList.setSelection(0);
                            AddDialog.this.projectList.setFocus();
                        }
                        event.doit = false;
                        AddDialog.this.enableOKButton(AddDialog.this.validate());
                    }
                }
            });
            this.projectList.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AddDialog.this.enableOKButton(AddDialog.this.validate());
                }
            });
            this.envVarText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AddDialog.this.enableOKButton(AddDialog.this.validate());
                }
            });
            this.createItems(this.projectList, "");
            filterText.setFocus();
            filterText.selectAll();
            if (this.projectList.getItemCount() == 0) {
                this.setErrorMessage(Messages.LinkMgmtAddDialogNoProjects);
            }
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            this.enableOKButton(false);
        }

        protected void enableOKButton(boolean value) {
            this.getButton(0).setEnabled(value);
        }

        protected void okPressed() {
            this.projectName = this.projectList.getSelection()[0];
            this.envVar = this.envVarText.getText();
            super.okPressed();
        }

        private boolean validate() {
            if (this.projectList.getSelectionCount() == 0) {
                this.setErrorMessage(Messages.LinkMgmtAddDialogNoProject);
                return false;
            }
            if (this.envVarText.getText() == null || this.envVarText.getText().trim().isEmpty()) {
                this.setErrorMessage(Messages.LinkMgmtAddDialogNoEnvVar);
                return false;
            }
            Optional entry = LinkManagementComposite.this.getLinkEntry(this.projectList.getSelection()[0], this.envVarText.getText().trim());
            if (entry.isPresent()) {
                this.setErrorMessage(NLS.bind((String)Messages.LinkMgmtAddDialogLinkExist, (Object)this.projectList.getSelection()[0], (Object)this.envVarText.getText().trim()));
                return false;
            }
            this.setErrorMessage(null);
            return true;
        }

        public LinkEntry getNewLinkEntry() {
            CodewindApplication app = ((LinkManagementComposite)LinkManagementComposite.this).srcApp.connection.getAppByName(this.projectName);
            return new LinkEntry(app, this.envVar);
        }

        private void createItems(org.eclipse.swt.widgets.List list, String filter) {
            list.removeAll();
            LinkManagementComposite.this.pattern.setPattern(filter == null || filter.isEmpty() ? "*" : "*" + filter + "*");
            ArrayList<String> names = new ArrayList<String>();
            for (CodewindApplication app : ((LinkManagementComposite)LinkManagementComposite.this).srcApp.connection.getApps()) {
                if (app == LinkManagementComposite.this.srcApp || app.getAppStatus() != AppStatus.STARTED || !app.isAvailable() || !LinkManagementComposite.this.pattern.matches(app.name)) continue;
                names.add(app.name);
            }
            Collections.sort(names);
            names.stream().forEach(name -> list.add(name));
        }

        protected Point getInitialSize() {
            Point point = super.getInitialSize();
            return new Point(550, point.y);
        }

        private String getFilterMessage() {
            return Messages.LinkMgmtAddDialogProjectFilterText;
        }
    }

    private class LinkEntry {
        private final CodewindApplication targetApp;
        private String envVar;
        private final ProjectLinks.LinkInfo info;

        public LinkEntry(CodewindApplication targetApp, String envVar) {
            this.targetApp = targetApp;
            this.envVar = envVar;
            this.info = null;
        }

        public LinkEntry(ProjectLinks.LinkInfo info) {
            this.targetApp = ((LinkManagementComposite)LinkManagementComposite.this).srcApp.connection.getAppByID(info.getProjectId());
            this.envVar = info.getEnvVar();
            this.info = info;
        }
    }
}

