/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.cli;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.TimeoutException;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.ProcessHelper;
import org.eclipse.codewind.core.internal.cli.CLIUtil;
import org.eclipse.codewind.core.internal.cli.ProjectLinks;
import org.eclipse.codewind.core.internal.constants.ProjectInfo;
import org.eclipse.codewind.core.internal.messages.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ProjectUtil {
    private static final String PROJECT_CMD = "project";
    private static final String[] CREATE_CMD = new String[]{"project", "create"};
    private static final String[] BIND_CMD = new String[]{"project", "bind"};
    private static final String[] REMOVE_CMD = new String[]{"project", "remove"};
    private static final String[] VALIDATE_CMD = new String[]{"project", "validate"};
    private static final String[] RESTART_CMD = new String[]{"project", "restart"};
    private static final String LINK_CMD = "link";
    private static final String[] LINK_LIST_CMD = new String[]{"project", "link", "list"};
    private static final String[] LINK_CREATE_CMD = new String[]{"project", "link", "create"};
    private static final String[] LINK_REMOVE_CMD = new String[]{"project", "link", "remove"};
    private static final String[] LINK_RENAME_CMD = new String[]{"project", "link", "rename"};
    private static final String URL_OPTION = "--url";
    private static final String NAME_OPTION = "--name";
    private static final String LANGUAGE_OPTION = "--language";
    private static final String TYPE_OPTION = "--type";
    private static final String PATH_OPTION = "--path";
    private static final String PROJECT_ID_OPTION = "--id";
    private static final String DELETE_OPTION = "--delete";
    private static final String STARTMODE_OPTION = "--startmode";
    private static final String TARGET_ID_OPTION = "--targetID";
    private static final String ENV_OPTION = "--env";
    private static final String NEW_ENV_OPTION = "--newEnv";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createProject(String name, String path, String url, String conid, IProgressMonitor monitor) throws IOException, JSONException, TimeoutException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.CreateProjectTaskLabel, (Object)name), (int)100);
        Process process = null;
        try {
            process = CLIUtil.runCWCTL(CLIUtil.GLOBAL_JSON_INSECURE, CREATE_CMD, new String[]{PATH_OPTION, path, URL_OPTION, url, "--conid", conid});
            ProcessHelper.ProcessResult result = ProcessHelper.waitForProcess(process, 500, 600, (IProgressMonitor)mon);
            CLIUtil.checkResult(CREATE_CMD, result, true);
            JSONObject resultJson = new JSONObject(result.getOutput());
            if (!"success".equals(resultJson.getString("status"))) {
                String msg = "Project create failed for project: " + name + " with output: " + result.getOutput();
                Logger.logError(msg);
                throw new IOException(msg);
            }
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bindProject(String name, String path, String language, String projectType, String conid, IProgressMonitor monitor) throws IOException, TimeoutException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.BindingProjectTaskLabel, (Object)name), (int)100);
        Process process = null;
        try {
            String[] options = new String[]{NAME_OPTION, name, LANGUAGE_OPTION, language, TYPE_OPTION, projectType, PATH_OPTION, path, "--conid", conid};
            process = CLIUtil.runCWCTL(CLIUtil.GLOBAL_JSON_INSECURE, BIND_CMD, options);
            ProcessHelper.ProcessResult result = ProcessHelper.waitForProcess(process, 500, 300, (IProgressMonitor)mon);
            CLIUtil.checkResult(BIND_CMD, result, false);
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
        }
    }

    public static ProjectInfo validateProject(String name, String path, String hint, String conid, IProgressMonitor monitor) throws IOException, JSONException, TimeoutException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.ValidateProjectTaskLabel, (Object)name), (int)100);
        Process process = null;
        try {
            process = hint == null ? CLIUtil.runCWCTL(CLIUtil.GLOBAL_JSON_INSECURE, VALIDATE_CMD, new String[]{PATH_OPTION, path, "--conid", conid}) : CLIUtil.runCWCTL(CLIUtil.GLOBAL_JSON_INSECURE, VALIDATE_CMD, new String[]{TYPE_OPTION, hint, PATH_OPTION, path, "--conid", conid});
            ProcessHelper.ProcessResult result = ProcessHelper.waitForProcess(process, 500, 300, (IProgressMonitor)mon);
            CLIUtil.checkResult(VALIDATE_CMD, result, true);
            JSONObject resultJson = new JSONObject(result.getOutput());
            if ("success".equals(resultJson.getString("status")) && resultJson.has("result")) {
                JSONObject typeJson = resultJson.getJSONObject("result");
                String language = typeJson.getString("language");
                String projectType = typeJson.getString("projectType");
                ProjectInfo projectInfo = new ProjectInfo(projectType, language);
                return projectInfo;
            }
            String msg = "Validation failed for project: " + name + " with output: " + result.getOutput();
            Logger.logError(msg);
            throw new IOException(msg);
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
        }
    }

    public static void removeProject(String name, String projectId, IProgressMonitor monitor) throws IOException, TimeoutException {
        ProjectUtil.removeProject(name, projectId, false, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeProject(String name, String projectId, boolean delete, IProgressMonitor monitor) throws IOException, TimeoutException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.RemoveProjectTaskLabel, (Object)name), (int)100);
        Process process = null;
        ArrayList<String> options = new ArrayList<String>();
        if (delete) {
            options.add(DELETE_OPTION);
        }
        options.add(PROJECT_ID_OPTION);
        options.add(projectId);
        try {
            process = CLIUtil.runCWCTL(CLIUtil.GLOBAL_JSON_INSECURE, REMOVE_CMD, options.toArray(new String[options.size()]));
            ProcessHelper.ProcessResult result = ProcessHelper.waitForProcess(process, 500, 300, (IProgressMonitor)mon);
            CLIUtil.checkResult(REMOVE_CMD, result, false);
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restartProject(String name, String projectId, String startMode, String conid, IProgressMonitor monitor) throws IOException, TimeoutException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.RestartProjectTaskLabel, (Object)name), (int)100);
        Process process = null;
        try {
            String[] options = new String[]{PROJECT_ID_OPTION, projectId, STARTMODE_OPTION, startMode, "--conid", conid};
            process = CLIUtil.runCWCTL(CLIUtil.GLOBAL_JSON_INSECURE, RESTART_CMD, options);
            ProcessHelper.ProcessResult result = ProcessHelper.waitForProcess(process, 500, 300, (IProgressMonitor)mon);
            CLIUtil.checkResult(RESTART_CMD, result, false);
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProjectLinks getLinks(String name, String projectId, IProgressMonitor monitor) throws IOException, JSONException, TimeoutException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.GetProjectLinksTaskLabel, (Object)name), (int)100);
        Process process = null;
        try {
            process = CLIUtil.runCWCTL(CLIUtil.GLOBAL_JSON_INSECURE, LINK_LIST_CMD, new String[]{PROJECT_ID_OPTION, projectId});
            ProcessHelper.ProcessResult result = ProcessHelper.waitForProcess(process, 500, 300, (IProgressMonitor)mon);
            CLIUtil.checkResult(LINK_LIST_CMD, result, true);
            ProjectLinks projectLinks = new ProjectLinks(new JSONArray(result.getOutput()));
            return projectLinks;
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createLink(String name, String projectId, String targetName, String targetId, String env, IProgressMonitor monitor) throws IOException, TimeoutException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.CreateProjectLinkTaskLabel, (Object[])new String[]{name, targetName, env}), (int)100);
        Process process = null;
        try {
            process = CLIUtil.runCWCTL(CLIUtil.GLOBAL_JSON_INSECURE, LINK_CREATE_CMD, new String[]{PROJECT_ID_OPTION, projectId, TARGET_ID_OPTION, targetId, ENV_OPTION, env});
            ProcessHelper.ProcessResult result = ProcessHelper.waitForProcess(process, 500, 300, (IProgressMonitor)mon);
            CLIUtil.checkResult(LINK_CREATE_CMD, result, false);
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLink(String name, String projectId, String targetName, String env, IProgressMonitor monitor) throws IOException, TimeoutException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.RemoveProjectLinkTaskLabel, (Object[])new String[]{name, targetName, env}), (int)100);
        Process process = null;
        try {
            process = CLIUtil.runCWCTL(CLIUtil.GLOBAL_JSON_INSECURE, LINK_REMOVE_CMD, new String[]{PROJECT_ID_OPTION, projectId, ENV_OPTION, env});
            ProcessHelper.ProcessResult result = ProcessHelper.waitForProcess(process, 500, 300, (IProgressMonitor)mon);
            CLIUtil.checkResult(LINK_REMOVE_CMD, result, false);
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renameLink(String name, String projectId, String env, String newEnv, IProgressMonitor monitor) throws IOException, TimeoutException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.RenameProjectLinkTaskLabel, (Object[])new String[]{name, env, newEnv}), (int)100);
        Process process = null;
        try {
            process = CLIUtil.runCWCTL(CLIUtil.GLOBAL_JSON_INSECURE, LINK_RENAME_CMD, new String[]{PROJECT_ID_OPTION, projectId, ENV_OPTION, env, NEW_ENV_OPTION, newEnv});
            ProcessHelper.ProcessResult result = ProcessHelper.waitForProcess(process, 500, 300, (IProgressMonitor)mon);
            CLIUtil.checkResult(LINK_RENAME_CMD, result, false);
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
        }
    }
}

