/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.constants.BuildStatus;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.actions.SelectionProviderAction;

public class StartBuildAction
extends SelectionProviderAction {
    protected CodewindApplication app;

    public StartBuildAction(ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.StartBuildActionLabel);
        this.setImageDescriptor(CodewindUIPlugin.getImageDescriptor("elcl16/build_exec.png"));
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        Object obj;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof CodewindApplication) {
            this.app = (CodewindApplication)obj;
            if (this.app.isAvailable() && this.app.getBuildStatus() != BuildStatus.IN_PROGRESS && this.app.getBuildStatus() != BuildStatus.QUEUED) {
                this.setEnabled(true);
                return;
            }
        }
        this.setEnabled(false);
    }

    public void run() {
        if (this.app == null) {
            Logger.logError((String)"StartBuildAction ran but no application was selected");
            return;
        }
        try {
            this.app.connection.requestProjectBuild(this.app, "build");
        }
        catch (Exception e) {
            Logger.logError((String)("Error requesting build for application: " + this.app.name), (Throwable)e);
            CoreUtil.openDialog((boolean)true, (String)NLS.bind((String)Messages.StartBuildError, (Object)this.app.name), (String)e.getMessage());
            return;
        }
    }
}

