/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.views;

import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CodewindManager;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.cli.InstallStatus;
import org.eclipse.codewind.core.internal.cli.InstallUtil;
import org.eclipse.codewind.core.internal.connection.LocalConnection;
import org.eclipse.codewind.core.internal.connection.RemoteConnection;
import org.eclipse.codewind.core.internal.constants.AppStatus;
import org.eclipse.codewind.core.internal.constants.BuildStatus;
import org.eclipse.codewind.core.internal.constants.DetailedAppStatus;
import org.eclipse.codewind.core.internal.constants.ProjectLanguage;
import org.eclipse.codewind.core.internal.constants.ProjectType;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IToolTipProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.navigator.IDescriptionProvider;

public class CodewindNavigatorLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider,
IDescriptionProvider,
IToolTipProvider {
    static final StyledString.Styler BOLD_FONT_STYLER = new BoldFontStyler();
    public static final StyledString.Styler ERROR_STYLER = StyledString.createColorRegistryStyler((String)"ERROR_COLOR", null);
    public static StyledString.Styler LINK_STYLER = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
            textStyle.underline = true;
        }
    };

    /*
     * Enabled aggressive block sorting
     */
    public String getText(Object element) {
        if (element instanceof CodewindManager) {
            return Messages.CodewindLabel;
        }
        if (element instanceof LocalConnection) {
            LocalConnection connection = (LocalConnection)element;
            String name = connection.getName();
            CodewindManager manager = CodewindManager.getManager();
            if (manager.getInstallerStatus() != null) {
                switch (manager.getInstallerStatus()) {
                    case INSTALLING: {
                        return name + "[" + Messages.CodewindInstallingQualifier + "]";
                    }
                    case UNINSTALLING: {
                        return name + "[" + Messages.CodewindUninstallingQualifier + "]";
                    }
                    case STARTING: {
                        return name + "[" + Messages.CodewindStartingQualifier + "]";
                    }
                    case STOPPING: {
                        return name + "[" + Messages.CodewindStoppingQualifier + "]";
                    }
                }
                return super.getText(element);
            }
            InstallStatus status = manager.getInstallStatus();
            if (status.isStarted()) {
                if (!connection.isConnected()) return name + " [" + Messages.CodewindErrorQualifier + "] (" + Messages.CodewindErrorMsg + ")";
                String text = name + " [" + Messages.CodewindRunningQualifier + "]";
                if (connection.getApps().size() != 0) return text;
                return text + " (" + Messages.CodewindConnectionNoProjects + ")";
            }
            if (status.isInstalled()) {
                if (!status.hasStartedVersions()) return name + " [" + Messages.CodewindNotStartedQualifier + "] (" + Messages.CodewindNotStartedMsg + ")";
                return name + "[" + NLS.bind((String)Messages.CodewindWrongVersionQualifier, (Object)status.getStartedVersionsString()) + "] (" + NLS.bind((String)Messages.CodewindWrongVersionMsg, (Object)InstallUtil.getVersion());
            }
            if (status.hasInstalledVersions()) {
                return name + "[" + NLS.bind((String)Messages.CodewindWrongVersionQualifier, (Object)status.getInstalledVersionsString()) + "] (" + NLS.bind((String)Messages.CodewindWrongVersionMsg, (Object)InstallUtil.getVersion());
            }
            if (!status.isUnknown()) return name + " [" + Messages.CodewindErrorQualifier + "] (" + Messages.CodewindErrorMsg + ")";
            String errorMsg = manager.getInstallerErrorMsg() != null ? Messages.CodewindErrorMsgWithDetails : Messages.CodewindErrorMsg;
            return name + " [" + Messages.CodewindErrorQualifier + "] (" + errorMsg + ")";
        }
        if (element instanceof RemoteConnection) {
            RemoteConnection connection = (RemoteConnection)element;
            String text = connection.getName();
            if (connection.isConnected()) {
                if (connection.getApps().size() != 0) return text;
                return text + " (" + Messages.CodewindConnectionNoProjects + ")";
            }
            String errorMsg = connection.getConnectionErrorMsg();
            if (errorMsg != null) return text + " (" + errorMsg + ")";
            errorMsg = Messages.CodewindDisconnected;
            return text + " (" + errorMsg + ")";
        }
        if (!(element instanceof CodewindApplication)) return super.getText(element);
        CodewindApplication app = (CodewindApplication)element;
        StringBuilder builder = new StringBuilder(app.name);
        IProject project = CoreUtil.getEclipseProject((CodewindApplication)app);
        if (project != null && !project.getName().equals(app.name)) {
            builder.append("(" + project.getName() + ")");
        }
        if (!app.isEnabled()) {
            builder.append(" [" + Messages.CodewindProjectDisabled + "]");
            return builder.toString();
        }
        AppStatus appStatus = app.getAppStatus();
        BuildStatus buildStatus = app.getBuildStatus();
        if (appStatus == AppStatus.UNKNOWN && buildStatus == BuildStatus.UNKOWN) {
            builder.append(" [" + Messages.CodewindProjectNoStatus + "]");
            return builder.toString();
        }
        if (appStatus != AppStatus.UNKNOWN) {
            DetailedAppStatus details = app.getAppStatusDetails();
            if (details != null && details.getMessage() != null) {
                builder.append(" [" + appStatus.getDisplayString(app.getStartMode()) + ": ");
                if (details.getSeverity() != null) {
                    builder.append("(" + details.getSeverity().displayString + ") ");
                }
                builder.append(Messages.CodewindHoverForDetails);
                builder.append("]");
            } else {
                builder.append(" [" + appStatus.getDisplayString(app.getStartMode()) + "]");
            }
        }
        if (buildStatus == BuildStatus.UNKOWN) return builder.toString();
        String buildDetails = app.getBuildDetails();
        if (buildDetails != null && !buildDetails.isEmpty()) {
            builder.append(" [" + buildStatus.getDisplayString() + ": " + buildDetails + "]");
            return builder.toString();
        }
        builder.append(" [" + buildStatus.getDisplayString() + "]");
        return builder.toString();
    }

    public StyledString getStyledText(Object element) {
        StyledString styledString;
        if (element instanceof CodewindManager) {
            return new StyledString(Messages.CodewindLabel);
        }
        if (element instanceof LocalConnection) {
            LocalConnection connection = (LocalConnection)element;
            CodewindManager manager = CodewindManager.getManager();
            styledString = new StyledString(connection.getName());
            if (manager.getInstallerStatus() != null) {
                switch (manager.getInstallerStatus()) {
                    case INSTALLING: {
                        styledString.append(" [" + Messages.CodewindInstallingQualifier + "]", StyledString.DECORATIONS_STYLER);
                        break;
                    }
                    case UNINSTALLING: {
                        styledString.append(" [" + Messages.CodewindUninstallingQualifier + "]", StyledString.DECORATIONS_STYLER);
                        break;
                    }
                    case STARTING: {
                        styledString.append(" [" + Messages.CodewindStartingQualifier + "]", StyledString.DECORATIONS_STYLER);
                        break;
                    }
                    case STOPPING: {
                        styledString.append(" [" + Messages.CodewindStoppingQualifier + "]", StyledString.DECORATIONS_STYLER);
                    }
                }
            } else {
                InstallStatus status = manager.getInstallStatus();
                if (status.isStarted()) {
                    if (connection.isConnected()) {
                        styledString.append(" [" + Messages.CodewindRunningQualifier + "]", StyledString.DECORATIONS_STYLER);
                        if (connection.getApps().size() == 0) {
                            styledString.append(" (" + Messages.CodewindConnectionNoProjects + ")", StyledString.DECORATIONS_STYLER);
                        }
                    } else {
                        styledString.append(" [" + Messages.CodewindErrorQualifier + "]", StyledString.DECORATIONS_STYLER);
                        styledString.append(" [" + Messages.CodewindErrorMsg + "]", ERROR_STYLER);
                    }
                } else if (status.isInstalled()) {
                    if (status.hasStartedVersions()) {
                        styledString.append(" [" + NLS.bind((String)Messages.CodewindWrongVersionQualifier, (Object)status.getStartedVersionsString()) + "]", StyledString.DECORATIONS_STYLER);
                        styledString.append(" (" + NLS.bind((String)Messages.CodewindWrongVersionMsg, (Object)InstallUtil.getVersion()) + ")", StyledString.QUALIFIER_STYLER);
                    } else {
                        styledString.append(" [" + Messages.CodewindNotStartedQualifier + "]", StyledString.DECORATIONS_STYLER);
                        styledString.append(" (" + Messages.CodewindNotStartedMsg + ")", StyledString.QUALIFIER_STYLER);
                    }
                } else if (status.hasInstalledVersions()) {
                    styledString.append(" [" + NLS.bind((String)Messages.CodewindWrongVersionQualifier, (Object)status.getInstalledVersionsString()) + "]", StyledString.DECORATIONS_STYLER);
                    styledString.append(" (" + NLS.bind((String)Messages.CodewindWrongVersionMsg, (Object)InstallUtil.getVersion()) + ")", StyledString.QUALIFIER_STYLER);
                } else if (status.isUnknown()) {
                    styledString.append(" [" + Messages.CodewindErrorQualifier + "]", StyledString.DECORATIONS_STYLER);
                    String errorMsg = manager.getInstallerErrorMsg() != null ? Messages.CodewindErrorMsgWithDetails : Messages.CodewindErrorMsg;
                    styledString.append(" (" + errorMsg + ")", ERROR_STYLER);
                } else {
                    styledString.append(" [" + Messages.CodewindNotInstalledQualifier + "]", StyledString.DECORATIONS_STYLER);
                    styledString.append(" (" + Messages.CodewindNotInstalledMsg + ")", StyledString.QUALIFIER_STYLER);
                }
            }
        } else if (element instanceof RemoteConnection) {
            RemoteConnection connection = (RemoteConnection)element;
            styledString = new StyledString(connection.getName());
            if (connection.isConnected()) {
                styledString.append(" [" + Messages.CodewindConnected + "]", StyledString.DECORATIONS_STYLER);
                if (connection.getApps().size() == 0) {
                    styledString.append(" (" + Messages.CodewindConnectionNoProjects + ")", StyledString.DECORATIONS_STYLER);
                }
            } else {
                styledString.append(" [" + Messages.CodewindDisconnected + "]", StyledString.DECORATIONS_STYLER);
                String errorMsg = connection.getConnectionErrorMsg();
                if (errorMsg == null) {
                    styledString.append(" (" + Messages.CodewindDisconnectedDetails + ")", StyledString.QUALIFIER_STYLER);
                } else {
                    styledString.append(" (" + errorMsg + ")", ERROR_STYLER);
                }
            }
        } else if (element instanceof CodewindApplication) {
            CodewindApplication app = (CodewindApplication)element;
            styledString = new StyledString(app.name);
            IProject project = CoreUtil.getEclipseProject((CodewindApplication)app);
            if (project != null && !project.getName().equals(app.name)) {
                styledString.append("(" + project.getName() + ")");
            }
            if (app.isEnabled()) {
                AppStatus appStatus = app.getAppStatus();
                BuildStatus buildStatus = app.getBuildStatus();
                if (appStatus == AppStatus.UNKNOWN && buildStatus == BuildStatus.UNKOWN) {
                    styledString.append(" [" + Messages.CodewindProjectNoStatus + "]", StyledString.DECORATIONS_STYLER);
                } else {
                    if (appStatus != AppStatus.UNKNOWN) {
                        DetailedAppStatus details = app.getAppStatusDetails();
                        if (details != null && details.getMessage() != null) {
                            StyledString.Styler styler;
                            styledString.append(" [" + appStatus.getDisplayString(app.getStartMode()) + ": ", StyledString.DECORATIONS_STYLER);
                            StyledString.Styler styler2 = styler = details.getSeverity() != null && details.getSeverity() == DetailedAppStatus.Severity.ERROR ? ERROR_STYLER : StyledString.QUALIFIER_STYLER;
                            if (details.getSeverity() != null) {
                                styledString.append("(" + details.getSeverity().displayString + ") ", styler);
                            }
                            styledString.append(Messages.CodewindHoverForDetails, styler);
                            styledString.append("]", StyledString.DECORATIONS_STYLER);
                        } else {
                            styledString.append(" [" + appStatus.getDisplayString(app.getStartMode()) + "]", StyledString.DECORATIONS_STYLER);
                        }
                    }
                    if (buildStatus != BuildStatus.UNKOWN) {
                        String buildDetails = app.getBuildDetails();
                        if (buildDetails != null) {
                            styledString.append(" [" + buildStatus.getDisplayString() + ": ", StyledString.DECORATIONS_STYLER);
                            styledString.append(buildDetails, StyledString.QUALIFIER_STYLER);
                            styledString.append("]", StyledString.DECORATIONS_STYLER);
                        } else {
                            styledString.append(" [" + buildStatus.getDisplayString() + "]", StyledString.DECORATIONS_STYLER);
                        }
                    }
                }
            } else {
                styledString.append(" [" + Messages.CodewindProjectDisabled + "]", StyledString.DECORATIONS_STYLER);
            }
        } else {
            styledString = new StyledString(this.getText(element));
        }
        return styledString;
    }

    public Image getImage(Object element) {
        return CodewindNavigatorLabelProvider.getCodewindImage(element);
    }

    public static Image getCodewindImage(Object element) {
        if (element instanceof CodewindManager) {
            return CodewindUIPlugin.getImage("codewind.png");
        }
        if (element instanceof LocalConnection) {
            return CodewindUIPlugin.getImage(((LocalConnection)element).isConnected() ? "obj16/local_active.png" : "obj16/local_inactive.png");
        }
        if (element instanceof RemoteConnection) {
            return CodewindUIPlugin.getImage(((RemoteConnection)element).isConnected() ? "obj16/remote_connected.png" : "obj16/remote_disconnected.png");
        }
        if (element instanceof CodewindApplication) {
            ProjectType type = ((CodewindApplication)element).projectType;
            if (type == ProjectType.TYPE_LIBERTY) {
                return CodewindUIPlugin.getImage("obj16/microprofile.png");
            }
            if (type == ProjectType.TYPE_NODEJS) {
                return CodewindUIPlugin.getImage("obj16/nodejs.png");
            }
            if (type == ProjectType.TYPE_SPRING) {
                return CodewindUIPlugin.getImage("obj16/spring.png");
            }
            if (type == ProjectType.TYPE_SWIFT) {
                return CodewindUIPlugin.getImage("obj16/swift.png");
            }
            ProjectLanguage lang = ((CodewindApplication)element).projectLanguage;
            if (lang.isGo()) {
                return CodewindUIPlugin.getImage("obj16/go.png");
            }
            if (lang.isJava()) {
                return CodewindUIPlugin.getImage("obj16/java.png");
            }
            if (lang.isJavaScript()) {
                return CodewindUIPlugin.getImage("obj16/nodejs.png");
            }
            if (lang.isPython()) {
                return CodewindUIPlugin.getImage("obj16/python.png");
            }
            if (lang.isSwift()) {
                return CodewindUIPlugin.getImage("obj16/swift.png");
            }
            return CodewindUIPlugin.getImage("obj16/generic_project.png");
        }
        return null;
    }

    public String getDescription(Object element) {
        if (element instanceof LocalConnection) {
            if (CodewindManager.getManager().getInstallStatus() == InstallStatus.UNKNOWN && CodewindManager.getManager().getInstallerErrorMsg() != null) {
                return CodewindManager.getManager().getInstallerErrorMsg();
            }
        } else if (element instanceof RemoteConnection) {
            RemoteConnection connection = (RemoteConnection)element;
            if (connection.getBaseURI() != null) {
                return connection.getBaseURI().toString();
            }
        } else if (element instanceof CodewindApplication) {
            CodewindApplication app = (CodewindApplication)element;
            if (app.getAppStatusDetails() != null && app.getAppStatusDetails().getMessage() != null) {
                return app.getAppStatusDetails().getMessage();
            }
            if (app.getRootUrl() != null && (app.getAppStatus() == AppStatus.STARTING || app.getAppStatus() == AppStatus.STARTED)) {
                return NLS.bind((String)Messages.CodewindDescriptionContextRoot, (Object)app.getRootUrl());
            }
        }
        return null;
    }

    public String getToolTipText(Object element) {
        DetailedAppStatus details;
        if (element instanceof CodewindApplication && (details = ((CodewindApplication)element).getAppStatusDetails()) != null && details.getMessage() != null) {
            return (details.getSeverity() == null ? "" : details.getSeverity().displayString + ": ") + details.getMessage();
        }
        return this.getDescription(element);
    }

    static class BoldFontStyler
    extends StyledString.Styler {
        BoldFontStyler() {
        }

        public void applyStyles(TextStyle textStyle) {
            Font boldFont;
            FontDescriptor boldDescriptor = FontDescriptor.createFrom((FontData)new FontData()).setStyle(1);
            textStyle.font = boldFont = boldDescriptor.createFont((Device)Display.getCurrent());
        }
    }
}

