/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.cli.RegistryUtil;
import org.eclipse.codewind.core.internal.cli.TemplateUtil;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.ImagePushRegistryInfo;
import org.eclipse.codewind.core.internal.connection.ProjectTemplateInfo;
import org.eclipse.codewind.core.internal.constants.ProjectLanguage;
import org.eclipse.codewind.core.internal.constants.ProjectType;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.IDEUtil;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.prefs.RegistryManagementDialog;
import org.eclipse.codewind.ui.internal.prefs.RepositoryManagementDialog;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SearchPattern;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class NewCodewindProjectPage
extends WizardNewProjectCreationPage {
    private static final Pattern projectNamePattern = Pattern.compile("^[a-zA-Z0-9_.-]+$");
    private CodewindConnection connection;
    private List<ProjectTemplateInfo> templateList;
    private SearchPattern pattern = new SearchPattern(35);
    private Text filterText;
    private Table selectionTable;
    private Text descriptionLabel;
    private Text styleLabel;
    private Text sourceLabel;
    private Composite manageReposComp;
    private Composite manageRegistriesComp;
    private Link manageReposLink;
    private Link manageRegistriesLink;

    protected NewCodewindProjectPage(CodewindConnection connection) {
        super(Messages.NewProjectPage_ShellTitle);
        this.setTitle(Messages.NewProjectPage_WizardTitle);
        this.setDescription(Messages.NewProjectPage_WizardDescription);
        this.connection = connection;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite composite = (Composite)this.getControl();
        this.createContents(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, CodewindUIPlugin.MAIN_CONTEXTID);
    }

    private void createContents(Composite parent) {
        Group templateGroup = new Group(parent, 0);
        templateGroup.setText(Messages.NewProjectPage_TemplateGroupLabel);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        layout.horizontalSpacing = 7;
        layout.verticalSpacing = 7;
        templateGroup.setLayout((Layout)layout);
        templateGroup.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.filterText = new Text((Composite)templateGroup, 2048);
        this.filterText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.filterText.setMessage(Messages.NewProjectPage_FilterMessage);
        Composite tableComp = new Composite((Composite)templateGroup, 0);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComp.setLayout((Layout)tableColumnLayout);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        tableComp.setLayoutData((Object)data);
        this.selectionTable = new Table(tableComp, 68352);
        this.selectionTable.setLayoutData((Object)new GridData(4, 4, true, true));
        final TableColumn templateColumn = new TableColumn(this.selectionTable, 0);
        templateColumn.setText(Messages.NewProjectPage_TemplateColumn);
        templateColumn.setResizable(true);
        templateColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NewCodewindProjectPage.sortTable(NewCodewindProjectPage.this.selectionTable, templateColumn);
            }
        });
        final TableColumn typeColumn = new TableColumn(this.selectionTable, 0);
        typeColumn.setText(Messages.NewProjectPage_TypeColumn);
        typeColumn.setResizable(true);
        typeColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NewCodewindProjectPage.sortTable(NewCodewindProjectPage.this.selectionTable, typeColumn);
            }
        });
        final TableColumn languageColumn = new TableColumn(this.selectionTable, 0);
        languageColumn.setText(Messages.NewProjectPage_LanguageColumn);
        languageColumn.setResizable(true);
        languageColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NewCodewindProjectPage.sortTable(NewCodewindProjectPage.this.selectionTable, languageColumn);
            }
        });
        this.selectionTable.setHeaderVisible(true);
        this.selectionTable.setLinesVisible(false);
        this.selectionTable.setSortDirection(1024);
        this.selectionTable.setSortColumn(templateColumn);
        this.createItems(this.selectionTable, "");
        Arrays.stream(this.selectionTable.getColumns()).forEach(TableColumn::pack);
        tableColumnLayout.setColumnData((Widget)templateColumn, (ColumnLayoutData)new ColumnWeightData(10, Math.max(250, templateColumn.getWidth()), true));
        tableColumnLayout.setColumnData((Widget)typeColumn, (ColumnLayoutData)new ColumnWeightData(4, Math.max(100, typeColumn.getWidth()), true));
        tableColumnLayout.setColumnData((Widget)languageColumn, (ColumnLayoutData)new ColumnWeightData(3, Math.max(75, languageColumn.getWidth()), true));
        ScrolledComposite detailsScroll = new ScrolledComposite((Composite)templateGroup, 512);
        data = new GridData(4, 4, true, true);
        data.widthHint = 300;
        data.heightHint = 70;
        detailsScroll.setLayoutData((Object)data);
        Composite detailsComp = new Composite((Composite)detailsScroll, 0);
        GridLayout detailsLayout = new GridLayout();
        detailsLayout.numColumns = 1;
        detailsComp.setLayout((Layout)detailsLayout);
        detailsComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.descriptionLabel = new Text(detailsComp, 74);
        this.descriptionLabel.setText("");
        GridData descData = new GridData(4, 2, false, false);
        this.descriptionLabel.setLayoutData((Object)descData);
        IDEUtil.normalizeBackground((Control)this.descriptionLabel, (Control)detailsComp);
        this.styleLabel = new Text(detailsComp, 74);
        this.styleLabel.setText("");
        GridData styleData = new GridData(4, 2, false, false);
        this.styleLabel.setLayoutData((Object)styleData);
        IDEUtil.normalizeBackground((Control)this.styleLabel, (Control)detailsComp);
        this.sourceLabel = new Text(detailsComp, 74);
        this.sourceLabel.setText("");
        GridData sourceData = new GridData(4, 2, false, false);
        this.sourceLabel.setLayoutData((Object)sourceData);
        IDEUtil.normalizeBackground((Control)this.sourceLabel, (Control)detailsComp);
        this.manageReposComp = new Composite(parent, 0);
        this.manageReposComp.setLayout((Layout)new GridLayout(1, false));
        this.manageReposComp.setLayoutData((Object)new GridData(3, 4, false, false, 2, 1));
        this.manageReposLink = new Link(this.manageReposComp, 0);
        this.manageReposLink.setText(Messages.NewProjectPage_ManageRepoLabel + " <a>" + Messages.NewProjectPage_ManageRepoLink + "</a>");
        this.manageReposLink.setToolTipText(Messages.NewProjectPage_ManageRepoTooltip);
        this.manageReposLink.setLayoutData((Object)new GridData(3, 2, false, false));
        this.manageReposLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                block5: {
                    try {
                        List repoList = TemplateUtil.listTemplateSources((String)NewCodewindProjectPage.this.connection.getConid(), (IProgressMonitor)new NullProgressMonitor());
                        final RepositoryManagementDialog repoDialog = new RepositoryManagementDialog(NewCodewindProjectPage.this.getShell(), NewCodewindProjectPage.this.connection, repoList);
                        if (repoDialog.open() != 0 || !repoDialog.hasChanges()) break block5;
                        IRunnableWithProgress runnable = new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                                SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.RepoUpdateTask, (int)100);
                                IStatus status = repoDialog.updateRepos((IProgressMonitor)mon.split(75));
                                if (!status.isOK()) {
                                    throw new InvocationTargetException(status.getException(), status.getMessage());
                                }
                                if (mon.isCanceled()) {
                                    return;
                                }
                                try {
                                    mon.setTaskName(Messages.NewProjectPage_RefreshTemplatesTask);
                                    NewCodewindProjectPage.this.templateList = TemplateUtil.listTemplates((boolean)true, (String)NewCodewindProjectPage.this.connection.getConid(), (IProgressMonitor)mon.split(25));
                                }
                                catch (Exception e) {
                                    throw new InvocationTargetException(e, Messages.NewProjectPage_RefreshTemplatesError);
                                }
                            }
                        };
                        try {
                            NewCodewindProjectPage.this.getWizard().getContainer().run(true, true, runnable);
                        }
                        catch (InvocationTargetException e) {
                            MessageDialog.openError((Shell)NewCodewindProjectPage.this.getShell(), (String)Messages.RepoUpdateErrorTitle, (String)e.getMessage());
                            return;
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                        NewCodewindProjectPage.this.updateSelectionTable();
                    }
                    catch (Exception e) {
                        MessageDialog.openError((Shell)NewCodewindProjectPage.this.getShell(), (String)Messages.RepoListErrorTitle, (String)NLS.bind((String)Messages.RepoListErrorMsg, (Object)e));
                    }
                }
            }
        });
        this.manageRegistriesComp = new Composite(parent, 0);
        this.manageRegistriesComp.setLayout((Layout)new GridLayout(1, false));
        this.manageRegistriesComp.setLayoutData((Object)new GridData(3, 4, false, false, 2, 1));
        this.manageRegistriesLink = new Link(this.manageRegistriesComp, 0);
        this.manageRegistriesLink.setText(Messages.ManageRegistriesLinkLabel + " <a>" + Messages.ManageRegistriesLinkText + "</a>");
        this.manageRegistriesLink.setToolTipText(Messages.ManageRegistriesLinkTooltip);
        this.manageRegistriesLink.setLayoutData((Object)new GridData(1, 2, false, false));
        this.manageRegistriesLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                block5: {
                    try {
                        List regList = RegistryUtil.listRegistrySecrets((String)NewCodewindProjectPage.this.connection.getConid(), (IProgressMonitor)new NullProgressMonitor());
                        ImagePushRegistryInfo pushReg = NewCodewindProjectPage.this.connection.requestGetPushRegistry();
                        final RegistryManagementDialog regDialog = new RegistryManagementDialog(NewCodewindProjectPage.this.getShell(), NewCodewindProjectPage.this.connection, regList, pushReg);
                        if (regDialog.open() != 0 || !regDialog.hasChanges()) break block5;
                        IRunnableWithProgress runnable = new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                                SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.RegUpdateTask, (int)100);
                                IStatus status = regDialog.updateRegistries((IProgressMonitor)mon.split(75));
                                if (!status.isOK()) {
                                    throw new InvocationTargetException(status.getException(), status.getMessage());
                                }
                                if (mon.isCanceled()) {
                                    return;
                                }
                            }
                        };
                        try {
                            NewCodewindProjectPage.this.getWizard().getContainer().run(true, true, runnable);
                        }
                        catch (InvocationTargetException e) {
                            MessageDialog.openError((Shell)NewCodewindProjectPage.this.getShell(), (String)Messages.RegUpdateErrorTitle, (String)e.getMessage());
                            return;
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                    catch (Exception e) {
                        MessageDialog.openError((Shell)NewCodewindProjectPage.this.getShell(), (String)Messages.RegListErrorTitle, (String)NLS.bind((String)Messages.RegListErrorMsg, (Object)e));
                    }
                }
            }
        });
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                NewCodewindProjectPage.this.updateSelectionTable();
            }
        });
        this.filterText.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if (event.keyCode == 0x1000002) {
                    if (NewCodewindProjectPage.this.selectionTable.getItemCount() > 0) {
                        NewCodewindProjectPage.this.selectionTable.setSelection(0);
                        NewCodewindProjectPage.this.updateDetails();
                        NewCodewindProjectPage.this.selectionTable.setFocus();
                    }
                    event.doit = false;
                    NewCodewindProjectPage.this.setPageComplete(NewCodewindProjectPage.this.validate());
                }
            }
        });
        this.selectionTable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                NewCodewindProjectPage.this.updateDetails();
                NewCodewindProjectPage.this.setPageComplete(NewCodewindProjectPage.this.validate());
            }
        });
        detailsScroll.addListener(11, event -> {
            int width = detailsScroll.getClientArea().width;
            descData.widthHint = width - detailsLayout.marginWidth;
            styleData.widthHint = width - detailsLayout.marginWidth;
            sourceData.widthHint = width - detailsLayout.marginWidth;
            Point size = detailsComp.computeSize(-1, -1);
            detailsScroll.setMinSize(size);
        });
        detailsScroll.setContent((Control)detailsComp);
        detailsScroll.setExpandHorizontal(true);
        detailsScroll.setExpandVertical(true);
        detailsScroll.setMinSize(detailsScroll.getContent().computeSize(-1, -1));
        this.initContent();
    }

    protected boolean canFinish() {
        return this.validate();
    }

    private boolean validate() {
        if (!this.validatePage()) {
            return false;
        }
        if (this.templateList == null || this.templateList.isEmpty()) {
            this.setErrorMessage(Messages.NewProjectPage_EmptyTemplateList);
            return false;
        }
        String projectName = this.getProjectName();
        if (projectName == null || projectName.isEmpty()) {
            this.setErrorMessage(Messages.NewProjectPage_EmptyProjectName);
            return false;
        }
        if (!projectNamePattern.matcher(projectName).matches()) {
            this.setErrorMessage(Messages.NewProjectPage_InvalidProjectName);
            return false;
        }
        if (this.connection.getAppByName(projectName) != null) {
            this.setErrorMessage(NLS.bind((String)Messages.NewProjectPage_ProjectExistsError, (Object)projectName));
            return false;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project != null && project.exists()) {
            this.setErrorMessage(NLS.bind((String)Messages.NewProjectPage_EclipseProjectExistsError, (Object)projectName));
            return false;
        }
        IPath location = this.getLocationPath();
        if (location == null || location.isEmpty()) {
            this.setErrorMessage(Messages.NewProjectPage_NoLocationError);
            return false;
        }
        IPath dataPath = CoreUtil.getCodewindDataPath();
        if (dataPath != null && dataPath.isPrefixOf(location)) {
            this.setErrorMessage(NLS.bind((String)Messages.ProjectLocationInCodewindDataDirError, (Object)dataPath.toOSString()));
            return false;
        }
        if (this.selectionTable.getSelectionCount() != 1) {
            this.setErrorMessage(Messages.NewProjectPage_NoTemplateSelected);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public ProjectTemplateInfo getProjectTemplateInfo() {
        int index;
        if (this.selectionTable != null && (index = this.selectionTable.getSelectionIndex()) >= 0) {
            TableItem item = this.selectionTable.getItem(index);
            return (ProjectTemplateInfo)item.getData();
        }
        return null;
    }

    public void setConnection(CodewindConnection connection) {
        this.connection = connection;
        this.initContent();
    }

    public void initContent() {
        if (this.connection == null) {
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(false);
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.NewProjectPage_GetTemplatesTask, (int)100);
                    NewCodewindProjectPage.this.templateList = TemplateUtil.listTemplates((boolean)true, (String)NewCodewindProjectPage.this.connection.getConid(), (IProgressMonitor)mon.split(100));
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            if (this.getWizard().getPageCount() > 0 && this.getWizard().getContainer() != null) {
                this.getWizard().getContainer().run(true, true, runnable);
            } else {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
            }
        }
        catch (InvocationTargetException e) {
            Logger.logError((String)("An error occurred getting the templates for the " + this.connection.getName() + " connection."), (Throwable)e.getTargetException());
            this.setErrorMessage(Messages.NewProjectPage_TemplateListError);
            return;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.templateList.isEmpty()) {
            this.setErrorMessage(Messages.NewProjectPage_EmptyTemplateList);
        } else {
            this.templateList.sort(new Comparator<ProjectTemplateInfo>(){

                @Override
                public int compare(ProjectTemplateInfo info1, ProjectTemplateInfo info2) {
                    return info1.getLabel().compareTo(info2.getLabel());
                }
            });
            this.createItems(this.selectionTable, this.getFilterText());
            if (this.selectionTable.getItemCount() > 0) {
                this.selectionTable.setSelection(0);
            }
            this.updateDetails();
        }
    }

    private void createItems(Table table, String filter) {
        table.removeAll();
        if (this.templateList == null || this.templateList.isEmpty()) {
            return;
        }
        this.pattern.setPattern("*" + filter + "*");
        for (ProjectTemplateInfo templateInfo : this.templateList) {
            String template = templateInfo.getLabel();
            String type = ProjectType.getDisplayName((String)templateInfo.getProjectType());
            String language = ProjectLanguage.getDisplayName((String)templateInfo.getLanguage());
            String description = templateInfo.getDescription();
            String source = templateInfo.getSource();
            if (!(this.pattern.matches(template) || type != null && this.pattern.matches(type) || language != null && this.pattern.matches(language) || description != null && this.pattern.matches(description)) && (source == null || !this.pattern.matches(source))) continue;
            TableItem item = new TableItem(table, 0);
            item.setText(0, template);
            if (type != null) {
                item.setText(1, type);
            }
            if (language != null) {
                item.setText(2, language);
            }
            item.setData((Object)templateInfo);
        }
    }

    public static void sortTable(Table table, TableColumn column) {
        int i;
        TableItem[] items = table.getItems();
        int rows = items.length;
        int dir = table.getSortDirection() == 1024 ? 1 : -1;
        TableColumn currentColumn = table.getSortColumn();
        int columnNum = 0;
        for (int j = 0; j < table.getColumnCount(); ++j) {
            if (!table.getColumn(j).equals(column)) continue;
            columnNum = j;
            break;
        }
        dir = column.equals(currentColumn) ? -dir : 1;
        int[] map = new int[rows];
        for (i = 0; i < rows; ++i) {
            map[i] = i;
        }
        for (i = 0; i < rows - 1; ++i) {
            for (int j = i + 1; j < rows; ++j) {
                TableItem a = items[map[i]];
                TableItem b = items[map[j]];
                if (a.getText(columnNum).toLowerCase().compareTo(b.getText(columnNum).toLowerCase()) * dir <= 0) continue;
                int t = map[i];
                map[i] = map[j];
                map[j] = t;
            }
        }
        for (i = 0; i < rows; ++i) {
            int n = map[i];
            TableItem item = new TableItem(table, 0);
            for (int j = 0; j < table.getColumnCount(); ++j) {
                item.setText(j, items[n].getText(j));
            }
            item.setData(items[n].getData());
            items[n].dispose();
        }
        table.setSortDirection(dir == 1 ? 1024 : 128);
        table.setSortColumn(column);
    }

    private void updateSelectionTable() {
        this.createItems(this.selectionTable, this.getFilterText());
        if (this.selectionTable.getItemCount() > 0) {
            this.selectionTable.select(0);
        }
        this.updateDetails();
        this.setPageComplete(this.validate());
    }

    private String getFilterText() {
        String text = null;
        if (this.filterText != null && !this.filterText.isDisposed()) {
            text = this.filterText.getText();
        }
        if (text == null) {
            text = "";
        }
        return text;
    }

    public void updateDetails() {
        TableItem[] items = this.selectionTable.getSelection();
        String description = "";
        String style = "";
        String source = "";
        boolean enabled = false;
        if (items.length == 1) {
            enabled = true;
            description = ((ProjectTemplateInfo)items[0].getData()).getDescription();
            if (description == null || description.isEmpty()) {
                description = Messages.NewProjectPage_DetailsNone;
            }
            if ((style = ((ProjectTemplateInfo)items[0].getData()).getProjectStyle()) == null || style.isEmpty()) {
                style = Messages.NewProjectPage_DetailsNone;
            }
            if ((source = ((ProjectTemplateInfo)items[0].getData()).getSource()) == null || source.isEmpty()) {
                source = Messages.NewProjectPage_DetailsNone;
            }
        }
        this.descriptionLabel.setText(NLS.bind((String)Messages.NewProjectPage_DescriptionLabel, (Object)description));
        this.styleLabel.setText(NLS.bind((String)Messages.NewProjectPage_StyleLabel, (Object)style));
        this.sourceLabel.setText(NLS.bind((String)Messages.NewProjectPage_SourceLabel, (Object)source));
        this.descriptionLabel.setEnabled(enabled);
        this.styleLabel.setEnabled(enabled);
        this.sourceLabel.setEnabled(enabled);
        this.resizeEntry(this.descriptionLabel);
        this.resizeEntry(this.styleLabel);
        this.resizeEntry(this.sourceLabel);
    }

    private void resizeEntry(Text text) {
        int width = text.getParent().getClientArea().width;
        text.setSize(width, text.computeSize((int)width, (int)-1).y);
        int newWidth = text.getParent().getClientArea().width;
        if (newWidth != width) {
            text.setSize(newWidth, text.computeSize((int)newWidth, (int)-1).y);
        }
    }
}

