/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.editors.ApplicationOverviewEditorInput;
import org.eclipse.codewind.ui.internal.editors.ApplicationOverviewEditorPart;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.SelectionProviderAction;

public class OpenAppOverviewAction
extends SelectionProviderAction {
    protected CodewindApplication app;

    public OpenAppOverviewAction(ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.OpenAppOverviewAction_Label);
        this.setImageDescriptor(CodewindUIPlugin.getImageDescriptor("codewind.png"));
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        Object obj;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof CodewindApplication) {
            this.app = (CodewindApplication)obj;
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    public void run() {
        if (this.app == null) {
            Logger.logError((String)"OpenAppOverviewAction ran but no application was selected");
            return;
        }
        OpenAppOverviewAction.openAppOverview(this.app);
    }

    public static void openAppOverview(CodewindApplication app) {
        IWorkbenchWindow workbenchWindow = CodewindUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        try {
            ApplicationOverviewEditorInput input = new ApplicationOverviewEditorInput(app);
            IEditorPart part = page.openEditor((IEditorInput)input, "org.eclipse.codewind.ui.editors.appOverview");
            if (!(part instanceof ApplicationOverviewEditorPart)) {
                Logger.logError((String)("Application overview editor part for the " + app.name + " application is the wrong type: " + part.getClass()));
            }
        }
        catch (Exception e) {
            Logger.logError((String)("An error occurred opening the editor for application: " + app.name), (Throwable)e);
        }
    }
}

