/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import java.util.Optional;
import org.eclipse.codewind.core.CodewindCorePlugin;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.cli.OtherUtil;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.ui.internal.IDEUtil;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.wizards.DiagnosticsDialog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleView;

public class DiagnosticsAction
extends SelectionProviderAction {
    private CodewindConnection conn;

    public DiagnosticsAction(ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.DiagnosticsActionLabel);
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        Object obj;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof CodewindConnection) {
            this.conn = (CodewindConnection)obj;
            this.setEnabled(this.conn.isConnected());
            return;
        }
        this.setEnabled(false);
    }

    public void run() {
        if (this.conn == null) {
            Logger.logError((String)"DiagnosticsAction ran but no connection was selected");
            return;
        }
        final DiagnosticsDialog dialog = new DiagnosticsDialog(Display.getDefault().getActiveShell(), this.conn);
        if (dialog.open() == 0) {
            Job job = new Job(NLS.bind((String)Messages.DiagnosticsActionJobLabel, (Object)this.conn.getName())){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.DiagnosticsActionJobLabel, (Object)DiagnosticsAction.this.conn.getName()), (int)100);
                        ILaunch launch = OtherUtil.startDiagnostics((String)DiagnosticsAction.this.conn.getName(), (String)DiagnosticsAction.this.conn.getConid(), (boolean)dialog.includeEclipseWorkspace(), (boolean)dialog.includeProjectInfo(), (IProgressMonitor)mon.split(70));
                        Optional<IConsole> consoleResult = IDEUtil.getConsoleForLaunch(launch);
                        while (!(mon.isCanceled() || launch.isTerminated() || consoleResult.isPresent())) {
                            try {
                                Thread.sleep(200L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            mon.worked(10);
                            mon.setWorkRemaining(30);
                            consoleResult = IDEUtil.getConsoleForLaunch(launch);
                        }
                        if (mon.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        if (consoleResult.isPresent()) {
                            IConsole console = consoleResult.get();
                            Display.getDefault().asyncExec(() -> {
                                IWorkbenchPage page;
                                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                                IWorkbenchPage iWorkbenchPage = page = window == null ? null : window.getActivePage();
                                if (page != null) {
                                    try {
                                        IConsoleView view = (IConsoleView)page.showView("org.eclipse.ui.console.ConsoleView");
                                        view.display(console);
                                    }
                                    catch (Exception e) {
                                        Logger.logError((String)"An error occurred trying to open the console view", (Throwable)e);
                                    }
                                }
                            });
                        } else {
                            Logger.logError((String)("Could not find the console for launch: " + launch));
                        }
                    }
                    catch (Exception e) {
                        Logger.logError((String)("An error occurred trying to generate diagnostics for connection: " + DiagnosticsAction.this.conn.getName()), (Throwable)e);
                        return new Status(4, "org.eclipse.codewind.ui", NLS.bind((String)Messages.DiagnosticsErrorMsg, (Object)DiagnosticsAction.this.conn.getName()), (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }

    public boolean showAction() {
        return this.conn != null && CodewindCorePlugin.getDefault().getPreferenceStore().getBoolean("enableSupportFeatures");
    }
}

