/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import java.util.ArrayList;
import org.eclipse.codewind.ui.internal.actions.OpenAppAction;
import org.eclipse.codewind.ui.internal.actions.RestartDebugModeAction;
import org.eclipse.codewind.ui.internal.actions.RestartRunModeAction;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;

public class RootActionProvider
extends CommonActionProvider {
    private OpenAppAction openAppAction;
    private RestartRunModeAction restartRunAction;
    private RestartDebugModeAction restartDebugAction;

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        StructuredViewer selProvider = aSite.getStructuredViewer();
        this.openAppAction = new OpenAppAction((ISelectionProvider)selProvider);
        this.restartRunAction = new RestartRunModeAction((ISelectionProvider)selProvider);
        this.restartDebugAction = new RestartDebugModeAction((ISelectionProvider)selProvider);
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler("org.eclipse.codewind.ui.openAppAction", (IAction)this.openAppAction);
        actionBars.setGlobalActionHandler("org.eclipse.codewind.ui.restartRunModeAction", (IAction)this.restartRunAction);
        actionBars.setGlobalActionHandler("org.eclipse.codewind.ui.restartDebugModeAction", (IAction)this.restartDebugAction);
        IToolBarManager cm = actionBars.getToolBarManager();
        IContributionItem[] items = cm.getItems();
        ArrayList<IAction> existingActions = new ArrayList<IAction>();
        for (IContributionItem item : items) {
            if (!(item instanceof ActionContributionItem)) continue;
            existingActions.add(((ActionContributionItem)item).getAction());
        }
        if (!existingActions.contains((Object)this.openAppAction)) {
            cm.appendToGroup("group.open", (IAction)this.openAppAction);
        }
        if (!existingActions.contains((Object)this.restartRunAction)) {
            cm.appendToGroup("group.open", (IAction)this.restartRunAction);
        }
        if (!existingActions.contains((Object)this.restartDebugAction)) {
            cm.appendToGroup("group.open", (IAction)this.restartDebugAction);
        }
    }
}

